/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi;

import java.io.File;
import java.io.InputStream;
import jexx.poi.AbstractExcel;
import jexx.poi.SheetReader;
import jexx.poi.exception.POIException;
import jexx.poi.meta.MetaSheetReader;
import jexx.poi.util.WorkbookUtil;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelReader
extends AbstractExcel {
    public ExcelReader(Workbook workbook) {
        this.workbook = workbook;
        this.loadMeta();
    }

    public ExcelReader(File excelFile) {
        this(WorkbookUtil.createBook(excelFile));
    }

    public ExcelReader(InputStream excelInputStream) {
        this(WorkbookUtil.createBook(excelInputStream));
    }

    private void loadMeta() {
        Sheet sheet = this.getSheet("__METADATA__");
        if (sheet != null) {
            MetaSheetReader reader = new MetaSheetReader(sheet);
            this.meta = reader.readMeta();
        }
    }

    public SheetReader sheet() {
        return this.sheet("Sheet1");
    }

    public SheetReader oneSheet() {
        Sheet sheet;
        int sheetNum = this.workbook.getNumberOfSheets();
        Sheet metaSheet = this.getSheet("__METADATA__");
        if (metaSheet != null) {
            if (--sheetNum != 1) {
                throw new POIException("there is not one sheet!");
            }
            int sheetIndex = this.workbook.getSheetIndex(metaSheet) == 0 ? 1 : 0;
            sheet = this.getSheetAt(sheetIndex + 1);
        } else {
            if (sheetNum != 1) {
                throw new POIException("there is not one sheet!");
            }
            sheet = this.getSheetAt(1);
        }
        return new SheetReader(sheet);
    }

    public SheetReader sheet(String sheetName) {
        if ("__METADATA__".equals(sheetName)) {
            return null;
        }
        Sheet sheet = this.workbook.getSheet(sheetName);
        if (sheet == null) {
            throw new POIException("Sheet {} not exist!", sheetName);
        }
        return new SheetReader(sheet);
    }
}

