/*
 * Decompiled with CFR 0.152.
 */
package jexx.poi;

import java.io.Closeable;
import jexx.io.IOUtil;
import jexx.poi.meta.Metas;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class AbstractExcel
implements Closeable {
    public static final String METADATA_SHEET_NAME = "__METADATA__";
    public static final String DEFAULT_SHEET_NAME = "Sheet1";
    protected Workbook workbook;
    protected Metas meta;

    public boolean hasMetaSheet() {
        return this.workbook.getSheet(METADATA_SHEET_NAME) != null;
    }

    public Metas getMetas() {
        return this.meta;
    }

    public boolean hasSheet(String sheetName) {
        return this.workbook.getSheet(sheetName) != null;
    }

    protected Sheet getOrCreateSheet(String sheetName) {
        Sheet sheet = this.workbook.getSheet(sheetName);
        if (sheet == null) {
            sheet = this.workbook.createSheet(sheetName);
        }
        return sheet;
    }

    protected Sheet getSheet(String sheetName) {
        return this.workbook.getSheet(sheetName);
    }

    protected Sheet getSheetAt(int sheetNum) {
        return this.workbook.getSheetAt(sheetNum - 1);
    }

    @Override
    public void close() {
        IOUtil.closeQuietly((Closeable)this.workbook);
    }
}

