/*
 * Decompiled with CFR 0.152.
 */
package jexx.mail;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import jexx.mail.Email;
import jexx.mail.EmailAddress;
import jexx.mail.EmailAttachment;
import jexx.mail.EmailMessage;
import jexx.mail.MailException;
import jexx.mail.MailSession;

public class SendMailSession
extends MailSession<Transport> {
    private static final String ALTERNATIVE = "alternative";
    private static final String RELATED = "related";
    private static final String CHARSET = ";charset=";
    private static final String INLINE = "inline";

    public SendMailSession(Session session, Transport transport) {
        super(session, transport);
    }

    @Override
    public Transport getService() {
        return (Transport)this.service;
    }

    public String sendMail(Email email) {
        try {
            MimeMessage msg = this.createMessage(email);
            this.getService().sendMessage((Message)msg, msg.getAllRecipients());
            return msg.getMessageID();
        }
        catch (MessagingException e) {
            e.printStackTrace();
            throw new MailException(e, "Failed to send email: {}", email);
        }
    }

    protected MimeMessage createMessage(Email email) throws MessagingException {
        Email clone = email.clone();
        MimeMessage newMsg = new MimeMessage(this.getSession());
        this.setPeople(clone, newMsg);
        this.setSubject(clone, newMsg);
        this.setSentDate(clone, newMsg);
        this.setHeaders(clone, newMsg);
        this.addBodyData(clone, newMsg);
        return newMsg;
    }

    private void setPeople(Email emailWithData, MimeMessage msgToSet) throws MessagingException {
        EmailAddress from = emailWithData.from();
        if (from != null) {
            msgToSet.setFrom((Address)from.toInternetAddress());
        }
        msgToSet.setReplyTo((Address[])EmailAddress.convert(emailWithData.replyTo()));
        this.setRecipients(emailWithData, msgToSet);
    }

    private void setRecipients(Email emailWithData, MimeMessage msgToSet) throws MessagingException {
        InternetAddress[] bcc;
        InternetAddress[] cc;
        InternetAddress[] to = EmailAddress.convert(emailWithData.to());
        if (to.length > 0) {
            msgToSet.setRecipients(Message.RecipientType.TO, (Address[])to);
        }
        if ((cc = EmailAddress.convert(emailWithData.cc())).length > 0) {
            msgToSet.setRecipients(Message.RecipientType.CC, (Address[])cc);
        }
        if ((bcc = EmailAddress.convert(emailWithData.bcc())).length > 0) {
            msgToSet.setRecipients(Message.RecipientType.BCC, (Address[])bcc);
        }
    }

    private void setSubject(Email emailWithData, MimeMessage msgToSet) throws MessagingException {
        if (emailWithData.subjectEncoding() != null) {
            msgToSet.setSubject(emailWithData.subject(), emailWithData.subjectEncoding());
        } else {
            msgToSet.setSubject(emailWithData.subject());
        }
    }

    private void setSentDate(Email emailWithData, MimeMessage msgToSet) throws MessagingException {
        Date date = emailWithData.sentDate();
        if (date == null) {
            date = new Date();
        }
        msgToSet.setSentDate(date);
    }

    private void setHeaders(Email emailWithData, MimeMessage msgToSet) throws MessagingException {
        Map<String, String> headers = emailWithData.headers();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                msgToSet.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    private void addBodyData(Email emailWithData, MimeMessage msgToSet) throws MessagingException {
        List<EmailMessage> messages = emailWithData.messages();
        int totalMessages = messages.size();
        ArrayList<EmailAttachment<? extends DataSource>> attachments = new ArrayList<EmailAttachment<? extends DataSource>>(emailWithData.attachments());
        if (attachments.isEmpty() && totalMessages == 1) {
            this.setContent(messages.get(0), (Part)msgToSet);
        } else {
            MimeMultipart multipart = new MimeMultipart();
            msgToSet.setContent((Multipart)multipart);
            MimeMultipart msgMultipart = new MimeMultipart(ALTERNATIVE);
            multipart.addBodyPart((BodyPart)this.getBaseBodyPart(msgMultipart));
            for (EmailMessage emailMessage : messages) {
                msgMultipart.addBodyPart((BodyPart)this.getBodyPart(emailMessage, attachments));
            }
            this.addAnyAttachments(attachments, multipart);
            msgToSet.setContent((Multipart)multipart);
        }
    }

    private void setContent(EmailMessage emailWithData, Part partToSet) throws MessagingException {
        partToSet.setContent((Object)emailWithData.getContent(), emailWithData.getMimeType() + CHARSET + emailWithData.getEncoding());
    }

    private MimeBodyPart getBaseBodyPart(MimeMultipart msgMultipart) throws MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setContent((Multipart)msgMultipart);
        return bodyPart;
    }

    private MimeBodyPart getBodyPart(EmailMessage emailMessage, List<EmailAttachment<? extends DataSource>> attachments) throws MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        List<EmailAttachment<? extends DataSource>> embeddedAttachments = this.filterEmbeddedAttachments(attachments, emailMessage);
        if (embeddedAttachments.isEmpty()) {
            this.setContent(emailMessage, (Part)bodyPart);
        } else {
            attachments.removeAll(embeddedAttachments);
            MimeMultipart relatedMultipart = new MimeMultipart(RELATED);
            MimeBodyPart messageData = new MimeBodyPart();
            this.setContent(emailMessage, (Part)messageData);
            relatedMultipart.addBodyPart((BodyPart)messageData);
            this.addAnyAttachments(embeddedAttachments, relatedMultipart);
            bodyPart.setContent((Multipart)relatedMultipart);
        }
        return bodyPart;
    }

    protected MimeBodyPart createAttachmentBodyPart(EmailAttachment<? extends DataSource> attachment) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        String attachmentName = attachment.getEncodedName();
        if (attachmentName != null) {
            part.setFileName(attachmentName);
        }
        part.setDataHandler(new DataHandler(attachment.getDataSource()));
        if (attachment.getContentId() != null) {
            part.setContentID("<" + attachment.getContentId() + ">");
        }
        if (attachment.isInline()) {
            part.setDisposition(INLINE);
        }
        return part;
    }

    protected List<EmailAttachment<? extends DataSource>> filterEmbeddedAttachments(List<EmailAttachment<? extends DataSource>> attachments, EmailMessage emailMessage) {
        ArrayList<EmailAttachment<? extends DataSource>> embeddedAttachments = new ArrayList<EmailAttachment<? extends DataSource>>();
        if (attachments == null || attachments.isEmpty() || emailMessage == null) {
            return embeddedAttachments;
        }
        Iterator<EmailAttachment<? extends DataSource>> iterator = attachments.iterator();
        while (iterator.hasNext()) {
            EmailAttachment<? extends DataSource> emailAttachment = iterator.next();
            if (!emailAttachment.isEmbeddedInto(emailMessage)) continue;
            embeddedAttachments.add(emailAttachment);
            iterator.remove();
        }
        return embeddedAttachments;
    }

    private void addAnyAttachments(List<EmailAttachment<? extends DataSource>> attachments, MimeMultipart multipart) throws MessagingException {
        for (EmailAttachment<? extends DataSource> attachment : attachments) {
            MimeBodyPart bodyPart = this.createAttachmentBodyPart(attachment);
            multipart.addBodyPart((BodyPart)bodyPart);
        }
    }
}

