/*
 * Decompiled with CFR 0.152.
 */
package jexx.mail;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;
import javax.mail.internet.MimeUtility;
import jexx.io.FastByteArrayOutputStream;
import jexx.io.IOUtil;
import jexx.mail.EmailAttachmentBuilder;
import jexx.mail.EmailMessage;
import jexx.mail.MailException;

public class EmailAttachment<T extends DataSource> {
    private final String name;
    private String contentId;
    private boolean isInline;
    private final T dataSource;
    private EmailMessage targetMessage;
    private int size = -1;

    public static EmailAttachmentBuilder with() {
        return new EmailAttachmentBuilder();
    }

    protected EmailAttachment(String name, String contentId, boolean isInline, T dataSource) {
        if (name != null) {
            try {
                this.name = MimeUtility.decodeText((String)name);
            }
            catch (UnsupportedEncodingException useexc) {
                throw new MailException(useexc);
            }
        } else {
            this.name = null;
        }
        this.contentId = contentId;
        this.isInline = isInline;
        this.dataSource = dataSource;
    }

    public String getName() {
        return this.name;
    }

    public String getEncodedName() {
        if (this.name == null) {
            return null;
        }
        try {
            return MimeUtility.encodeText((String)this.name);
        }
        catch (UnsupportedEncodingException ueex) {
            throw new MailException(ueex);
        }
    }

    public String getContentId() {
        return this.contentId;
    }

    public boolean isEmbedded() {
        return this.contentId != null;
    }

    public boolean isInline() {
        return this.isInline;
    }

    protected EmailAttachment<T> setInline(boolean isInline) {
        this.isInline = isInline;
        return this;
    }

    protected EmailAttachment<T> setContentId(String contentId) {
        this.contentId = contentId;
        return this;
    }

    public EmailAttachment<T> setEmbeddedMessage(EmailMessage emailMessage) {
        this.targetMessage = emailMessage;
        return this;
    }

    public boolean isEmbeddedInto(EmailMessage emailMessage) {
        return this.targetMessage == emailMessage;
    }

    public T getDataSource() {
        return this.dataSource;
    }

    public String getContentType() {
        return this.dataSource.getContentType();
    }

    public int getSize() {
        return this.size;
    }

    protected EmailAttachment<T> setSize(int size) {
        this.size = size;
        return this;
    }

    public byte[] toByteArray() {
        FastByteArrayOutputStream out = this.size != -1 ? new FastByteArrayOutputStream(this.size) : new FastByteArrayOutputStream();
        this.writeToStream((OutputStream)out);
        return out.toByteArray();
    }

    public void writeToFile(File destination) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(destination);
            this.writeToStream(out);
        }
        catch (IOException e) {
            try {
                throw new MailException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtil.closeQuietly((Closeable)out);
    }

    public void writeToStream(OutputStream out) {
        InputStream input = null;
        try {
            input = this.getDataSource().getInputStream();
            IOUtil.copy((InputStream)input, (OutputStream)out);
        }
        catch (IOException ioex) {
            throw new MailException(ioex);
        }
        finally {
            IOUtil.closeQuietly((Closeable)input);
        }
    }
}

