/*
 * Decompiled with CFR 0.152.
 */
package jexx.mail;

import java.io.UnsupportedEncodingException;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import jexx.lang.Charsets;
import jexx.util.ArrayUtil;
import jexx.util.StringUtil;

public class EmailAddress {
    public static final EmailAddress[] EMPTY_ARRAY = new EmailAddress[0];
    private final String email;
    private final String personalName;

    public EmailAddress(String personalName, String email) {
        this.email = email;
        this.personalName = personalName;
    }

    public static EmailAddress of(String personalName, String email) {
        return new EmailAddress(personalName, email);
    }

    public static EmailAddress of(String address) {
        if (!StringUtil.endWithChar((String)(address = address.trim()), (char)'>')) {
            return new EmailAddress(null, address);
        }
        int ndx = address.lastIndexOf(60);
        if (ndx == -1) {
            return new EmailAddress(null, address);
        }
        String email = address.substring(ndx + 1, address.length() - 1);
        String personalName = address.substring(0, ndx).trim();
        return new EmailAddress(personalName, email);
    }

    public static EmailAddress of(InternetAddress internetAddress) {
        return new EmailAddress(internetAddress.getPersonal(), internetAddress.getAddress());
    }

    public static EmailAddress of(Address address) {
        return EmailAddress.of(address.toString());
    }

    public String getEmail() {
        return this.email;
    }

    public String getPersonalName() {
        return this.personalName;
    }

    public String toString() {
        if (this.personalName == null) {
            return this.email;
        }
        return this.personalName + " <" + this.email + '>';
    }

    public InternetAddress toInternetAddress() throws AddressException {
        try {
            return new InternetAddress(this.email, this.personalName, Charsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ueex) {
            throw new AddressException(ueex.toString());
        }
    }

    public static EmailAddress[] of(Address ... addresses) {
        if (addresses == null) {
            return EMPTY_ARRAY;
        }
        if (addresses.length == 0) {
            return EMPTY_ARRAY;
        }
        EmailAddress[] res = new EmailAddress[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            res[i] = EmailAddress.of(addresses[i]);
        }
        return res;
    }

    public static EmailAddress[] of(String ... addresses) {
        if (ArrayUtil.isEmpty((Object[])addresses)) {
            return EMPTY_ARRAY;
        }
        EmailAddress[] res = new EmailAddress[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            res[i] = EmailAddress.of(addresses[i]);
        }
        return res;
    }

    public static InternetAddress[] convert(EmailAddress[] addresses) throws MessagingException {
        if (addresses == null) {
            return new InternetAddress[0];
        }
        int numRecipients = addresses.length;
        InternetAddress[] address = new InternetAddress[numRecipients];
        for (int i = 0; i < numRecipients; ++i) {
            address[i] = addresses[i].toInternetAddress();
        }
        return address;
    }
}

