/*
 * Decompiled with CFR 0.152.
 */
package jexx.http.httpclient;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import jexx.exception.UtilException;
import jexx.http.Http;
import jexx.http.HttpException;
import jexx.http.HttpHeader;
import jexx.io.IOUtil;
import jexx.log.Log;
import jexx.log.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class ApacheHttpClientImpl
implements Http {
    private static final Log LOG = LogFactory.get(ApacheHttpClientImpl.class);
    private CloseableHttpClient httpclient;

    public ApacheHttpClientImpl() {
        this(null, null);
    }

    public ApacheHttpClientImpl(InputStream certStream, char[] password) {
        boolean useCert = certStream != null || password != null;
        this.httpclient = this.createHttpClient(useCert, certStream, password);
    }

    private CloseableHttpClient createHttpClient(boolean useCert, InputStream certStream, char[] password) {
        try {
            BasicHttpClientConnectionManager connManager;
            if (useCert) {
                KeyStore ks = KeyStore.getInstance("PKCS12");
                ks.load(certStream, password);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(ks, password);
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(kmf.getKeyManagers(), null, new SecureRandom());
                SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1"}, null, (HostnameVerifier)new DefaultHostnameVerifier());
                connManager = new BasicHttpClientConnectionManager((Lookup)RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build(), null, null, null);
            } else {
                connManager = new BasicHttpClientConnectionManager((Lookup)RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build(), null, null, null);
            }
            CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connManager).build();
            return closeableHttpClient;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            throw new UtilException((Throwable)e);
        }
        finally {
            IOUtil.closeQuietly((Closeable)certStream);
        }
    }

    private URI uri(String url, Map<String, Object> params) throws HttpException {
        try {
            URIBuilder builder = new URIBuilder(url);
            if (params != null) {
                params.forEach((k, v) -> builder.addParameter(k, v != null ? v.toString() : ""));
            }
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new HttpException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doRequest(HttpUriRequest request) throws IOException {
        byte[] byArray;
        CloseableHttpResponse response = null;
        try {
            response = this.httpclient.execute(request);
            byArray = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(response);
            throw throwable;
        }
        IOUtil.closeQuietly((Closeable)response);
        return byArray;
    }

    protected void wrapForm(HttpEntityEnclosingRequestBase request, Map<String, Object> params, List<HttpHeader> headers) throws UnsupportedEncodingException {
        if (params != null) {
            ArrayList paramList = new ArrayList();
            params.forEach((k, v) -> paramList.add(new BasicNameValuePair(k, v != null ? v.toString() : "")));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramList);
            request.setEntity((HttpEntity)entity);
            if (headers != null) {
                for (HttpHeader header : headers) {
                    request.setHeader(header.getName(), header.getValue());
                }
            }
        }
    }

    protected void wrapBody(HttpEntityEnclosingRequestBase request, String body, List<HttpHeader> headers) throws UnsupportedCharsetException {
        if (body != null) {
            StringEntity entity = new StringEntity(body, "UTF-8");
            if (headers != null) {
                for (HttpHeader header : headers) {
                    request.setHeader(header.getName(), header.getValue());
                }
            }
            request.setEntity((HttpEntity)entity);
        }
    }

    @Override
    public byte[] get(String url, List<HttpHeader> headers) throws HttpException {
        return this.get(url, null, headers);
    }

    @Override
    public byte[] get(String url, Map<String, Object> params, List<HttpHeader> headers) throws HttpException {
        try {
            URI uri = this.uri(url, params);
            HttpGet httpGet = new HttpGet(uri);
            return this.doRequest((HttpUriRequest)httpGet);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    @Override
    public byte[] put(String url, List<HttpHeader> headers) throws HttpException {
        return this.put(url, new HashMap<String, Object>(), headers);
    }

    @Override
    public byte[] put(String url, Map<String, Object> params, List<HttpHeader> headers) throws HttpException {
        try {
            URI uri = this.uri(url, null);
            HttpPut httpPut = new HttpPut(uri);
            this.wrapForm((HttpEntityEnclosingRequestBase)httpPut, params, headers);
            return this.doRequest((HttpUriRequest)httpPut);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    @Override
    public byte[] put(String url, String body, List<HttpHeader> headers) throws HttpException {
        try {
            URI uri = this.uri(url, null);
            HttpPut httpPut = new HttpPut(uri);
            this.wrapBody((HttpEntityEnclosingRequestBase)httpPut, body, headers);
            return this.doRequest((HttpUriRequest)httpPut);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    @Override
    public byte[] delete(String url, List<HttpHeader> headers) throws HttpException {
        return this.delete(url, null, headers);
    }

    @Override
    public byte[] delete(String url, Map<String, Object> params, List<HttpHeader> headers) throws HttpException {
        try {
            URI uri = this.uri(url, params);
            HttpDelete httpGet = new HttpDelete(uri);
            return this.doRequest((HttpUriRequest)httpGet);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    @Override
    public byte[] post(String url, List<HttpHeader> headers) throws HttpException {
        return this.post(url, new HashMap<String, Object>(), headers);
    }

    @Override
    public byte[] post(String url, Map<String, Object> params, List<HttpHeader> headers) throws HttpException {
        try {
            URI uri = this.uri(url, null);
            HttpPost post = new HttpPost(uri);
            this.wrapForm((HttpEntityEnclosingRequestBase)post, params, headers);
            return this.doRequest((HttpUriRequest)post);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    @Override
    public byte[] post(String url, String body, List<HttpHeader> headers) throws HttpException {
        try {
            URI uri = this.uri(url, null);
            HttpPost post = new HttpPost(uri);
            this.wrapBody((HttpEntityEnclosingRequestBase)post, body, headers);
            return this.doRequest((HttpUriRequest)post);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    @Override
    public void close() {
        IOUtil.closeQuietly((Closeable)this.httpclient);
    }
}

