/*
 * Decompiled with CFR 0.152.
 */
package jexx.http;

import java.io.Closeable;
import java.io.InputStream;
import jexx.exception.UtilException;
import jexx.http.Http;
import jexx.http.httpclient.ApacheHttpClientHttpFactory;
import jexx.io.IOUtil;
import jexx.log.Log;
import jexx.log.LogFactory;

public abstract class HttpFactory {
    private static final Log LOG = LogFactory.get();
    private static volatile HttpFactory currentHttpFactory;
    private static final Object lock;
    private String name;
    protected InputStream certStream;
    protected char[] password;

    public HttpFactory(String name) {
        this.name = name;
    }

    public static HttpFactory createFactory() {
        return HttpFactory.createFactory(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpFactory createFactory(InputStream certStream, char[] password) {
        if (currentHttpFactory == null) {
            Object object = lock;
            synchronized (object) {
                if (currentHttpFactory == null) {
                    currentHttpFactory = HttpFactory.detectFactory();
                    IOUtil.closeQuietly((Closeable)certStream);
                    HttpFactory.currentHttpFactory.certStream = certStream;
                    HttpFactory.currentHttpFactory.password = password;
                }
            }
        }
        return currentHttpFactory;
    }

    private static HttpFactory detectFactory() {
        if (currentHttpFactory == null) {
            try {
                currentHttpFactory = new ApacheHttpClientHttpFactory();
                LOG.info("found ApacheHttpClientHttpFactory", new Object[0]);
            }
            catch (NoClassDefFoundError error) {
                throw new UtilException("\u8bf7\u5bfc\u5165httpclient");
            }
        }
        return currentHttpFactory;
    }

    public abstract Http createHttp();

    public static Http get() {
        return HttpFactory.createFactory().createHttp();
    }

    protected void checkExist(Class<?> clazz) {
    }

    static {
        lock = new Object();
    }
}

