/*
 * Decompiled with CFR 0.152.
 */
package cn.jeeweb.ui.tags.view;

import cn.jeeweb.beetl.tags.annotation.BeetlTagName;
import cn.jeeweb.beetl.tags.exception.BeetlTagException;
import cn.jeeweb.common.utils.ObjectUtils;
import cn.jeeweb.common.utils.Reflections;
import cn.jeeweb.common.utils.SpringContextHolder;
import cn.jeeweb.common.utils.StringUtils;
import cn.jeeweb.common.utils.fastjson.FastjsonPropertyPreFilter;
import cn.jeeweb.common.utils.fastjson.FastjsonUnXssFilter;
import cn.jeeweb.ui.tags.form.support.FreemarkerFormTagHelper;
import cn.jeeweb.ui.tags.html.manager.HtmlComponentManager;
import cn.jeeweb.ui.tags.tag.AbstractGridHtmlTag;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@BeetlTagName(value="view.treeview")
public class TreeviewTag
extends AbstractGridHtmlTag {
    private String id = "treeview";
    private String dataUrl = "";
    private Object datas;
    private String onNodeSelected = "";
    protected String treeviewSettingCallback = "";

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDataUrl() {
        return this.dataUrl;
    }

    public void setDataUrl(String dataUrl) {
        this.dataUrl = dataUrl;
    }

    public Object getDatas() {
        return this.datas;
    }

    public void setDatas(Object datas) {
        this.datas = datas;
    }

    public String getOnNodeSelected() {
        return this.onNodeSelected;
    }

    public void setOnNodeSelected(String onNodeSelected) {
        this.onNodeSelected = onNodeSelected;
    }

    public String getTreeviewSettingCallback() {
        return this.treeviewSettingCallback;
    }

    public void setTreeviewSettingCallback(String treeviewSettingCallback) {
        this.treeviewSettingCallback = treeviewSettingCallback;
    }

    @Override
    public int doStartTag() throws BeetlTagException {
        if (this.staticAttributes != null) {
            this.staticAttributes.clear();
        }
        Field[] field = ((Object)((Object)this)).getClass().getDeclaredFields();
        for (int j = 0; j < field.length; ++j) {
            Field field2 = field[j];
            if (!ObjectUtils.isBaseDataType(field2.getType())) continue;
            String name = field[j].getName();
            this.setStaticAttribute(name, Reflections.invokeGetter((Object)((Object)this), (String)name));
        }
        return this.EVAL_PAGE;
    }

    public int doEndTag() throws BeetlTagException {
        try {
            this.writeFragment();
        }
        catch (BeetlTagException e) {
            e.printStackTrace();
        }
        return this.EVAL_PAGE;
    }

    private void writeFragment() throws BeetlTagException {
        HashMap<String, Object> rootMap = new HashMap<String, Object>();
        String ctx = (String)this.ctx.globalVar.get("ctxPath");
        String adminPath = ctx + "";
        String staticPath = ctx + "/static";
        rootMap.put("appPath", ctx);
        rootMap.put("adminPath", adminPath);
        rootMap.put("staticPath", staticPath);
        if (this.datas != null) {
            String initDatas = "";
            List dataList = (List)this.datas;
            if (dataList != null && dataList.size() > 0) {
                Class<?> clazz = dataList.get(0).getClass();
                FastjsonPropertyPreFilter fastjsonPropertyPreFilter = new FastjsonPropertyPreFilter(clazz, "text,href,tags,nodes");
                FastjsonUnXssFilter fastjsonUnXssFilter = new FastjsonUnXssFilter();
                SerializeFilter[] filters = new SerializeFilter[]{fastjsonPropertyPreFilter, fastjsonUnXssFilter};
                initDatas = JSON.toJSONString((Object)this.datas, (SerializeFilter[])filters, (SerializerFeature[])new SerializerFeature[0]);
            }
            if (StringUtils.isEmpty((String)initDatas)) {
                initDatas = "[]";
            }
            rootMap.put("initDatas", initDatas);
        }
        Map<String, Object> staticMap = FreemarkerFormTagHelper.getTagStatic((Object)this, this.ctx);
        rootMap.putAll(staticMap);
        HtmlComponentManager htmlComponentManager = (HtmlComponentManager)SpringContextHolder.getApplicationContext().getBean(HtmlComponentManager.class);
        String fragment = htmlComponentManager.getFragmentComponent("bootstrap-treeview", rootMap);
        if (!StringUtils.isEmpty((String)fragment) && !fragment.equals("null")) {
            try {
                this.ctx.byteWriter.writeString(fragment);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

