/*
 * Decompiled with CFR 0.152.
 */
package cn.jeeweb.ui.tags.html.resolver;

import java.io.InputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class HtmlComponentDTDEntityResolver
implements EntityResolver,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlComponentDTDEntityResolver.class);
    private static final String HOP_DYNAMIC_STATEMENT = "http://www.jeeweb.cn/dtd/";

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        InputSource source = null;
        if (systemId != null) {
            LOGGER.debug("trying to resolve system-id [" + systemId + "]");
            if (systemId.startsWith(HOP_DYNAMIC_STATEMENT)) {
                LOGGER.debug("recognized hop html component namespace attempting to resolve on classpath under cn/jeeweb/core/tags/html/dtd/");
                source = this.resolveOnClassPath(publicId, systemId, HOP_DYNAMIC_STATEMENT);
            }
        }
        return source;
    }

    private InputSource resolveOnClassPath(String publicId, String systemId, String namespace) {
        InputSource source = null;
        String path = "dtd/html-component-1.0.dtd";
        InputStream dtdStream = this.resolveInHtmlNamespace(path);
        if (dtdStream != null) {
            LOGGER.debug("Located [%s] in classpath", (Object)systemId);
            source = new InputSource(dtdStream);
            source.setPublicId(publicId);
            source.setSystemId(systemId);
        }
        return source;
    }

    protected InputStream resolveInHtmlNamespace(String path) {
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }
}

