/*
 * Decompiled with CFR 0.152.
 */
package cn.jeeweb.ui.tags.html.manager;

import cn.jeeweb.common.utils.CacheUtils;
import cn.jeeweb.common.utils.ObjectParseHelper;
import cn.jeeweb.common.utils.StringUtils;
import cn.jeeweb.ui.tags.html.builder.HtmlComponentBuilder;
import cn.jeeweb.ui.tags.html.builder.NoneHtmlComponentBuilder;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class HtmlComponentManager {
    protected HtmlComponentBuilder dynamicStatementBuilder = null;
    protected static final String HTML_COMPONENT_CACHE_NAME = "htmlComponentCache";
    protected static final String HTML_COMPONENT_PRE_NAME_JS = "js_";
    protected static final String HTML_COMPONENT_PRE_NAME_CSS = "css_";
    protected static final String HTML_COMPONENT_PRE_NAME_FRAGMENT = "fragment_";
    public static final String COMPONENT_TYPE_JS = "js";
    public static final String COMPONENT_TYPE_CSS = "css";
    public static final String COMPONENT_TYPE_FRAGMENT = "fragment";

    public void setDynamicStatementBuilder(HtmlComponentBuilder dynamicStatementBuilder) {
        this.dynamicStatementBuilder = dynamicStatementBuilder;
    }

    public void init() throws IOException {
        if (this.dynamicStatementBuilder == null) {
            this.dynamicStatementBuilder = new NoneHtmlComponentBuilder();
        }
        this.dynamicStatementBuilder.init();
        Map<String, String> cssComponents = this.dynamicStatementBuilder.getCssComponents();
        Map<String, String> jsComponents = this.dynamicStatementBuilder.getJsComponents();
        Map<String, String> fragmentComponents = this.dynamicStatementBuilder.getFragmentComponents();
        this.setCache(cssComponents, HTML_COMPONENT_PRE_NAME_CSS);
        this.setCache(jsComponents, HTML_COMPONENT_PRE_NAME_JS);
        this.setCache(fragmentComponents, HTML_COMPONENT_PRE_NAME_FRAGMENT);
    }

    private void setCache(Map<String, String> cssComponents, String htmlComponentPreName) {
        for (Map.Entry<String, String> entry : cssComponents.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            CacheUtils.put((String)HTML_COMPONENT_CACHE_NAME, (String)(htmlComponentPreName + key), (Object)value);
        }
    }

    public String getComponent(String componentType, String name) {
        if (componentType.equals(COMPONENT_TYPE_JS)) {
            return ObjectParseHelper.stringVauleOf((Object)CacheUtils.get((String)HTML_COMPONENT_CACHE_NAME, (String)(HTML_COMPONENT_PRE_NAME_JS + name)));
        }
        if (componentType.equals(COMPONENT_TYPE_CSS)) {
            return ObjectParseHelper.stringVauleOf((Object)CacheUtils.get((String)HTML_COMPONENT_CACHE_NAME, (String)(HTML_COMPONENT_PRE_NAME_CSS + name)));
        }
        if (componentType.equals(COMPONENT_TYPE_FRAGMENT)) {
            return ObjectParseHelper.stringVauleOf((Object)CacheUtils.get((String)HTML_COMPONENT_CACHE_NAME, (String)(HTML_COMPONENT_PRE_NAME_FRAGMENT + name)));
        }
        return "";
    }

    public String getComponent(String componentType, String name, Map<String, Object> dataMap) {
        try {
            String content = this.getComponent(componentType, name);
            String tempname = StringUtils.hashKeyForDisk((String)content);
            Configuration configuration = new Configuration();
            configuration.setNumberFormat("#");
            StringTemplateLoader stringLoader = new StringTemplateLoader();
            stringLoader.putTemplate(tempname, content);
            Template template = new Template(tempname, (Reader)new StringReader(content));
            StringWriter stringWriter = new StringWriter();
            template.process(dataMap, (Writer)stringWriter);
            configuration.setTemplateLoader((TemplateLoader)stringLoader);
            content = stringWriter.toString();
            return content;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getJsComponent(String name) {
        return this.getComponent(COMPONENT_TYPE_JS, name);
    }

    public String getJsComponent(String name, Map<String, Object> dataMap) {
        return this.getComponent(COMPONENT_TYPE_JS, name, dataMap);
    }

    public String getCssComponent(String name) {
        return this.getComponent(COMPONENT_TYPE_CSS, name);
    }

    public String getCssComponent(String name, Map<String, Object> dataMap) {
        return this.getComponent(COMPONENT_TYPE_CSS, name, dataMap);
    }

    public String getFragmentComponent(String name) {
        return this.getComponent(COMPONENT_TYPE_FRAGMENT, name);
    }

    public String getFragmentComponent(String name, Map<String, Object> dataMap) {
        return this.getComponent(COMPONENT_TYPE_FRAGMENT, name, dataMap);
    }

    public static void clear() {
        CacheUtils.remove((String)HTML_COMPONENT_CACHE_NAME, (String)HTML_COMPONENT_CACHE_NAME);
    }
}

