/*
 * Decompiled with CFR 0.152.
 */
package cn.jeeweb.ui.tags.html.builder;

import cn.jeeweb.ui.tags.html.builder.HtmlComponentBuilder;
import cn.jeeweb.ui.tags.html.exception.HtmlComponentException;
import cn.jeeweb.ui.tags.html.resolver.HtmlComponentDTDEntityResolver;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.xml.sax.EntityResolver;

public class DefaultHtmlComponentBuilder
implements HtmlComponentBuilder,
ResourceLoaderAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHtmlComponentBuilder.class);
    private Map<String, String> jsComponents = Maps.newHashMap();
    private Map<String, String> cssComponents = Maps.newHashMap();
    private Map<String, String> fragmentComponents = Maps.newHashMap();
    private String[] fileNames = new String[0];
    private ResourceLoader resourceLoader;
    private EntityResolver entityResolver = new HtmlComponentDTDEntityResolver();

    public void setFileNames(String[] fileNames) {
        this.fileNames = fileNames;
    }

    @Override
    public Map<String, String> getJsComponents() {
        return this.jsComponents;
    }

    @Override
    public Map<String, String> getCssComponents() {
        return this.cssComponents;
    }

    @Override
    public Map<String, String> getFragmentComponents() {
        return this.fragmentComponents;
    }

    @Override
    public void init() throws IOException {
        this.cssComponents.clear();
        this.jsComponents.clear();
        this.fragmentComponents.clear();
        boolean flag = this.resourceLoader instanceof ResourcePatternResolver;
        for (String file : this.fileNames) {
            if (flag) {
                Resource[] resources = ((ResourcePatternResolver)this.resourceLoader).getResources(file);
                this.buildMap(resources);
                continue;
            }
            Resource resource = ((ResourcePatternResolver)this.resourceLoader).getResource(file);
            this.buildMap(resource);
        }
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    private void buildMap(Resource[] resources) throws IOException {
        if (resources == null) {
            return;
        }
        for (Resource resource : resources) {
            this.buildMap(resource);
        }
    }

    private void buildMap(Resource resource) {
        try {
            Document document = this.read(resource.getInputStream());
            if (DefaultHtmlComponentBuilder.isHtmlComponentXml(document)) {
                Element dynamicHibernateStatement = document.getRootElement();
                Iterator rootChildren = dynamicHibernateStatement.elementIterator();
                while (rootChildren.hasNext()) {
                    Element element = (Element)rootChildren.next();
                    String elementName = element.getName();
                    if ("js".equals(elementName)) {
                        this.putStatementToCacheMap(resource, element, this.jsComponents);
                        continue;
                    }
                    if ("css".equals(elementName)) {
                        this.putStatementToCacheMap(resource, element, this.cssComponents);
                        continue;
                    }
                    if (!"fragment".equals(elementName)) continue;
                    this.putStatementToCacheMap(resource, element, this.fragmentComponents);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
            throw new HtmlComponentException(e);
        }
    }

    private Document read(InputStream inputStream) throws MalformedURLException, DocumentException {
        SAXReader reader = new SAXReader();
        reader.setEntityResolver(this.entityResolver);
        Document document = reader.read(inputStream);
        return document;
    }

    private void putStatementToCacheMap(Resource resource, Element element, Map<String, String> statementMap) throws IOException {
        String statementId = element.attribute("name").getText().toLowerCase();
        Validate.notEmpty((CharSequence)statementId);
        if (statementMap.containsKey(statementId)) {
            throw new HtmlComponentException("\u91cd\u590d\u7684\u7ec4\u5efa\u8bed\u53e5\u5b9a\u4e49\u5728\u6587\u4ef6:" + resource.getURI() + "\u4e2d\uff0c\u5fc5\u987b\u4fdd\u8bc1name\u201c" + statementId + "\u201d\u7684\u552f\u4e00.");
        }
        String queryText = element.getText().trim();
        statementMap.put(statementId, queryText);
    }

    private static boolean isHtmlComponentXml(Document document) {
        return "html-component".equals(document.getRootElement().getName());
    }
}

