/*
 * Decompiled with CFR 0.152.
 */
package cn.jeeweb.ui.tags.html;

import cn.jeeweb.beetl.tags.TagSupport;
import cn.jeeweb.beetl.tags.exception.BeetlTagException;
import cn.jeeweb.common.utils.SpringContextHolder;
import cn.jeeweb.common.utils.StringUtils;
import cn.jeeweb.ui.tags.html.manager.HtmlComponentManager;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;

public abstract class AbstractHtmlTag
extends TagSupport {
    private static final String[] SUPPORT_TYPES = new String[]{"CSS", "JS"};
    private String name = "";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getHtmlComponents() {
        return null;
    }

    public abstract String[] getSupportTypes();

    public int doStartTag() throws BeetlTagException {
        return this.EVAL_PAGE;
    }

    public int doEndTag() throws BeetlTagException {
        try {
            String[] components;
            String content = "";
            if (StringUtils.isEmpty((String)this.name)) {
                return this.EVAL_PAGE;
            }
            for (String component : components = this.name.split(",")) {
                if (!this.isComponent(component)) continue;
                String[] types = this.getSupportTypes();
                if (types == null) {
                    types = SUPPORT_TYPES;
                }
                for (String type : types) {
                    String componentContent = this.getComponentHtml(component.toLowerCase(), type);
                    if (StringUtils.isEmpty((String)componentContent)) continue;
                    content = content + componentContent + "\r\n";
                }
            }
            content = this.parseContent(content);
            this.ctx.byteWriter.writeString(content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        return this.EVAL_PAGE;
    }

    public String getComponentHtml(String component, String type) {
        HtmlComponentManager htmlComponentManager = (HtmlComponentManager)SpringContextHolder.getApplicationContext().getBean(HtmlComponentManager.class);
        try {
            String content = "";
            if (type.equals("CSS")) {
                content = htmlComponentManager.getCssComponent(component);
            } else if (type.equals("JS")) {
                content = htmlComponentManager.getJsComponent(component);
            } else if (type.equals("FRAGMENT")) {
                content = htmlComponentManager.getFragmentComponent(component);
            }
            return content;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String parseContent(String content) throws TemplateException, IOException {
        HashMap<String, String> rootMap = new HashMap<String, String>();
        String ctx = (String)this.ctx.globalVar.get("ctxPath");
        String adminPath = ctx + "";
        String staticPath = ctx + "/static";
        rootMap.put("ctx", ctx);
        rootMap.put("adminPath", adminPath);
        rootMap.put("staticPath", staticPath);
        String tempname = StringUtils.hashKeyForDisk((String)content);
        Configuration configuration = new Configuration();
        configuration.setNumberFormat("#");
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        stringLoader.putTemplate(tempname, content);
        Template template = new Template(tempname, (Reader)new StringReader(content));
        StringWriter stringWriter = new StringWriter();
        template.process(rootMap, (Writer)stringWriter);
        configuration.setTemplateLoader((TemplateLoader)stringLoader);
        content = stringWriter.toString();
        return content;
    }

    private boolean isComponent(String name) {
        return true;
    }
}

