/*
 * Decompiled with CFR 0.152.
 */
package cn.jeeweb.ui.tags.grid;

import cn.jeeweb.beetl.tags.annotation.BeetlTagName;
import cn.jeeweb.beetl.tags.dict.Dict;
import cn.jeeweb.beetl.tags.dict.DictUtils;
import cn.jeeweb.beetl.tags.exception.BeetlTagException;
import cn.jeeweb.common.utils.MessageUtils;
import cn.jeeweb.common.utils.ObjectUtils;
import cn.jeeweb.common.utils.StringUtils;
import cn.jeeweb.ui.tags.grid.DataGridTag;
import cn.jeeweb.ui.tags.tag.AbstractGridHtmlTag;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@BeetlTagName(value="grid.query")
public class DataGridQueryTag
extends AbstractGridHtmlTag {
    private String label;
    private String name;
    private String queryMode = "input";
    private String condition = "eq";
    private String dict;
    private Map<String, Object> queryStaticAttributes;
    private Map<String, Object> queryDynamicAttributes;
    private DataGridTag parentTag = null;

    public int doEndTag() throws BeetlTagException {
        this.parentTag = (DataGridTag)((Object)this.ctx.globalVar.get("parent_variable_name"));
        this.label = MessageUtils.getMessageOrSelf((String)this.label, (Object[])new Object[0]);
        this.addQuery();
        return this.EVAL_PAGE;
    }

    private void addQuery() {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("name", this.name);
        queryMap.put("label", this.label);
        if (!StringUtils.isEmpty((String)this.dict)) {
            queryMap.put("dict", this.dict);
        }
        queryMap.put("queryMode", this.queryMode);
        queryMap.put("condition", this.condition);
        if (this.queryDynamicAttributes != null) {
            queryMap.putAll(this.queryDynamicAttributes);
        }
        if (this.queryStaticAttributes != null) {
            queryMap.putAll(this.queryStaticAttributes);
        }
        if (!queryMap.containsKey("class")) {
            queryMap.put("class", "form-control");
        }
        if (this.queryMode.equals("radio") || this.queryMode.equals("checkbox")) {
            queryMap.put("class", queryMap.get("class") + " i-checks");
        }
        this.parentTag.addQuery(queryMap);
    }

    public String dictToFormatterValue(String dict) {
        String dictStr = "";
        List dictList = DictUtils.getDictList((String)dict);
        for (Dict dictEntity : dictList) {
            if (!StringUtils.isEmpty((String)dictStr)) {
                dictStr = dictStr + ";";
            }
            dictStr = dictStr + dictEntity.getValue() + ":" + dictEntity.getLabel();
        }
        return dictStr;
    }

    @Override
    public void setStaticAttribute(String localName, Object value) throws BeetlTagException {
        if (this.staticAttributes == null) {
            this.staticAttributes = new HashMap();
        }
        if (this.queryStaticAttributes == null) {
            this.queryStaticAttributes = new HashMap<String, Object>();
        }
        if (!ObjectUtils.isNullOrEmpty((Object)value)) {
            if (localName.equals("query")) {
                return;
            }
            if (localName.equals("condition") || localName.startsWith("query_")) {
                localName = localName.replace("query_", localName);
                this.queryStaticAttributes.put(localName, value);
            } else {
                this.staticAttributes.put(localName, value);
            }
        }
        if (localName.equals("label")) {
            this.staticAttributes.put(localName, MessageUtils.getMessageOrSelf((String)((String)value), (Object[])new Object[0]));
        }
    }

    @Override
    public void setDynamicAttribute(String localName, Object value) throws BeetlTagException {
        if (this.dynamicAttributes == null) {
            this.dynamicAttributes = new HashMap();
        }
        if (this.queryDynamicAttributes == null) {
            this.queryDynamicAttributes = new HashMap<String, Object>();
        }
        if (localName.equals("condition") || localName.startsWith("query_")) {
            localName = localName.replace("query_", "");
            this.queryDynamicAttributes.put(localName, value);
        } else {
            this.dynamicAttributes.put(localName, value);
        }
        if (localName.equals("label")) {
            this.dynamicAttributes.put(localName, MessageUtils.getMessageOrSelf((String)((String)value), (Object[])new Object[0]));
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getDict() {
        return this.dict;
    }

    public void setDict(String dict) {
        this.dict = dict;
    }

    public String getQueryMode() {
        return this.queryMode;
    }

    public void setQueryMode(String queryMode) {
        this.queryMode = queryMode;
    }
}

