/*
 * Decompiled with CFR 0.152.
 */
package cn.jeeweb.ui.tags.grid;

import cn.jeeweb.beetl.tags.annotation.BeetlTagName;
import cn.jeeweb.beetl.tags.dict.Dict;
import cn.jeeweb.beetl.tags.dict.DictUtils;
import cn.jeeweb.beetl.tags.exception.BeetlTagException;
import cn.jeeweb.common.utils.MapUtils;
import cn.jeeweb.common.utils.MessageUtils;
import cn.jeeweb.common.utils.ObjectUtils;
import cn.jeeweb.common.utils.StringUtils;
import cn.jeeweb.ui.tags.grid.DataGridTag;
import cn.jeeweb.ui.tags.tag.AbstractGridHtmlTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@BeetlTagName(value="grid.column")
public class DataGridColumnTag
extends AbstractGridHtmlTag {
    private static final String[] keys = new String[]{"prefix", "suffix", "formatterValue", "formatterClass", "formatterColor", "imageWidth", "imageHeight", "dict", "dateformat"};
    private String label;
    private String name;
    private String queryMode = "input";
    private int width = 120;
    private Boolean query = Boolean.FALSE;
    private String condition = "eq";
    private String align = "left";
    private Boolean sortable = Boolean.TRUE;
    private Boolean checkbox = Boolean.TRUE;
    private Boolean hidden = Boolean.FALSE;
    private String dict;
    private String formatter;
    private String formatoptions;
    private String prefix;
    private String suffix;
    private String formatterValue;
    private String formatterClass;
    private String formatterColor;
    private String imageWidth;
    private String imageHeight;
    private String dateformat;
    private String columnSetting = "{}";
    private String columnSettingCallback = "";
    private Boolean editable = Boolean.FALSE;
    private String edittype = "text";
    private String editdateformat = "yyyy-mm-dd";
    private String editoptions = "";
    private String editrules;
    private String datatype;
    private String nullmsg;
    private String errormsg;
    private Map<String, Object> queryStaticAttributes;
    private Map<String, Object> queryDynamicAttributes;
    private DataGridTag parentTag = null;

    public int doEndTag() throws BeetlTagException {
        this.parentTag = (DataGridTag)((Object)this.ctx.globalVar.get("parent_variable_name"));
        this.label = MessageUtils.getMessageOrSelf((String)this.label, (Object[])new Object[0]);
        this.addQuery();
        this.addColumn();
        return this.EVAL_PAGE;
    }

    private void addQuery() {
        if (this.query.booleanValue()) {
            HashMap<String, Object> queryMap = new HashMap<String, Object>();
            queryMap.put("name", this.name);
            queryMap.put("label", this.label);
            if (!StringUtils.isEmpty((String)this.dict)) {
                queryMap.put("dict", this.dict);
            } else if (!StringUtils.isEmpty((String)this.formatterValue)) {
                String dict = this.name + "_" + this.formatterValue.hashCode();
                queryMap.put("dict", dict);
                this.parentTag.putColumnDict(dict, this.formatterValueToDict(this.formatterValue));
            }
            queryMap.put("queryMode", this.queryMode);
            queryMap.put("condition", this.condition);
            if (this.queryDynamicAttributes != null) {
                queryMap.putAll(this.queryDynamicAttributes);
            }
            if (this.queryStaticAttributes != null) {
                queryMap.putAll(this.queryStaticAttributes);
            }
            if (!queryMap.containsKey("class")) {
                queryMap.put("class", "form-control");
            }
            if (this.queryMode.equals("radio") || this.queryMode.equals("checkbox")) {
                queryMap.put("class", queryMap.get("class") + " i-checks");
            }
            this.parentTag.addQuery(queryMap);
        }
    }

    private List<Dict> formatterValueToDict(String formatterValue) {
        String[] dicts = formatterValue.split(";");
        ArrayList<Dict> dictList = new ArrayList<Dict>();
        for (int i = 0; i < dicts.length; ++i) {
            String[] dictMap;
            String dict = dicts[i];
            if (StringUtils.isEmpty((String)dict) || (dictMap = dict.split(":")).length != 2) continue;
            Dict dictBean = new Dict();
            dictBean.setLabel(dictMap[1]);
            dictBean.setValue(dictMap[0]);
            dictList.add(dictBean);
        }
        return dictList;
    }

    private void addColumn() {
        HashMap<String, Object> columnMap = new HashMap<String, Object>();
        columnMap.putAll(this.staticAttributes);
        if (!StringUtils.isEmpty((String)this.editoptions)) {
            columnMap.put("editoptions", this.editoptions + "()");
        }
        if (this.editable.booleanValue()) {
            if (this.edittype.equals("select") && columnMap.get(this.editoptions) == null && !StringUtils.isEmpty((String)this.dict) && StringUtils.isEmpty((String)this.editoptions)) {
                columnMap.put("editoptions", this.dict + "SelectEditoptions");
            }
            if (this.edittype.equals("date")) {
                if (StringUtils.isEmpty((String)this.editoptions)) {
                    columnMap.put("editoptions", "date");
                }
                columnMap.put("edittype", "text");
            }
        }
        if (!StringUtils.isEmpty((String)this.dict)) {
            this.parentTag.putColumnDict(this.dict);
        }
        if (StringUtils.isEmpty((String)this.formatter) && MapUtils.containsOrKeys(columnMap, (String[])keys).booleanValue()) {
            this.formatter = "label";
            columnMap.put("formatter", this.formatter);
        }
        if (!StringUtils.isEmpty((String)this.dict) && StringUtils.isEmpty((String)this.formatterValue)) {
            this.formatterValue = this.dictToFormatterValue(this.dict);
            columnMap.put("formatterValue", this.formatterValue);
        }
        this.parentTag.addColumn(columnMap);
    }

    public String dictToFormatterValue(String dict) {
        String dictStr = "";
        List dictList = DictUtils.getDictList((String)dict);
        for (Dict dictEntity : dictList) {
            if (!StringUtils.isEmpty((String)dictStr)) {
                dictStr = dictStr + ";";
            }
            dictStr = dictStr + dictEntity.getValue() + ":" + dictEntity.getLabel();
        }
        return dictStr;
    }

    @Override
    public void setStaticAttribute(String localName, Object value) throws BeetlTagException {
        if (this.staticAttributes == null) {
            this.staticAttributes = new HashMap();
        }
        if (this.queryStaticAttributes == null) {
            this.queryStaticAttributes = new HashMap<String, Object>();
        }
        if (!ObjectUtils.isNullOrEmpty((Object)value)) {
            if (localName.equals("query")) {
                return;
            }
            if (localName.equals("condition") || localName.startsWith("query_")) {
                localName = localName.replace("query_", localName);
                this.queryStaticAttributes.put(localName, value);
            } else {
                this.staticAttributes.put(localName, value);
            }
        }
        if (localName.equals("label")) {
            this.staticAttributes.put(localName, MessageUtils.getMessageOrSelf((String)((String)value), (Object[])new Object[0]));
        }
    }

    @Override
    public void setDynamicAttribute(String localName, Object value) throws BeetlTagException {
        if (this.dynamicAttributes == null) {
            this.dynamicAttributes = new HashMap();
        }
        if (this.queryDynamicAttributes == null) {
            this.queryDynamicAttributes = new HashMap<String, Object>();
        }
        if (localName.equals("condition") || localName.startsWith("query_")) {
            localName = localName.replace("query_", "");
            this.queryDynamicAttributes.put(localName, value);
        } else {
            this.dynamicAttributes.put(localName, value);
        }
        if (localName.equals("label")) {
            this.dynamicAttributes.put(localName, MessageUtils.getMessageOrSelf((String)((String)value), (Object[])new Object[0]));
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public Boolean getQuery() {
        return this.query;
    }

    public void setQuery(Boolean query) {
        this.query = query;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getAlign() {
        return this.align;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public Boolean getSortable() {
        return this.sortable;
    }

    public void setSortable(Boolean sortable) {
        this.sortable = sortable;
    }

    public Boolean getCheckbox() {
        return this.checkbox;
    }

    public void setCheckbox(Boolean checkbox) {
        this.checkbox = checkbox;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public String getDict() {
        return this.dict;
    }

    public void setDict(String dict) {
        this.dict = dict;
    }

    public String getQueryMode() {
        return this.queryMode;
    }

    public void setQueryMode(String queryMode) {
        this.queryMode = queryMode;
    }

    public String getDateformat() {
        return this.dateformat;
    }

    public void setDateformat(String dateformat) {
        this.dateformat = dateformat;
    }

    public String getColumnSetting() {
        return this.columnSetting;
    }

    public void setColumnSetting(String columnSetting) {
        this.columnSetting = columnSetting;
    }

    public String getColumnSettingCallback() {
        return this.columnSettingCallback;
    }

    public void setColumnSettingCallback(String columnSettingCallback) {
        this.columnSettingCallback = columnSettingCallback;
    }

    public String getFormatter() {
        return this.formatter;
    }

    public void setFormatter(String formatter) {
        this.formatter = formatter;
    }

    public String getFormatoptions() {
        return this.formatoptions;
    }

    public void setFormatoptions(String formatoptions) {
        this.formatoptions = formatoptions;
    }

    public Boolean getEditable() {
        return this.editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public String getEdittype() {
        return this.edittype;
    }

    public void setEdittype(String edittype) {
        this.edittype = edittype;
    }

    public String getEditoptions() {
        return this.editoptions;
    }

    public void setEditoptions(String editoptions) {
        this.editoptions = editoptions;
    }

    public String getEditdateformat() {
        return this.editdateformat;
    }

    public void setEditdateformat(String editdateformat) {
        this.editdateformat = editdateformat;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getFormatterValue() {
        return this.formatterValue;
    }

    public void setFormatterValue(String formatterValue) {
        this.formatterValue = formatterValue;
    }

    public String getFormatterClass() {
        return this.formatterClass;
    }

    public void setFormatterClass(String formatterClass) {
        this.formatterClass = formatterClass;
    }

    public String getFormatterColor() {
        return this.formatterColor;
    }

    public void setFormatterColor(String formatterColor) {
        this.formatterColor = formatterColor;
    }

    public String getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(String imageWidth) {
        this.imageWidth = imageWidth;
    }

    public String getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(String imageHeight) {
        this.imageHeight = imageHeight;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
    }

    public String getNullmsg() {
        return this.nullmsg;
    }

    public void setNullmsg(String nullmsg) {
        this.nullmsg = nullmsg;
    }

    public String getErrormsg() {
        return this.errormsg;
    }

    public void setErrormsg(String errormsg) {
        this.errormsg = errormsg;
    }

    public String getEditrules() {
        return this.editrules;
    }

    public void setEditrules(String editrules) {
        this.editrules = editrules;
    }
}

