/*
 * Decompiled with CFR 0.152.
 */
package cn.jeeweb.ui.tags.form;

import cn.jeeweb.beetl.tags.annotation.BeetlTagName;
import cn.jeeweb.beetl.tags.exception.BeetlTagException;
import cn.jeeweb.beetl.tags.form.TagWriter;
import cn.jeeweb.beetl.tags.form.TextareaTag;
import cn.jeeweb.common.utils.SpringContextHolder;
import cn.jeeweb.common.utils.StringUtils;
import cn.jeeweb.ui.tags.html.manager.HtmlComponentManager;
import java.util.HashMap;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@BeetlTagName(value="form.editor")
public class EditorTag
extends TextareaTag {
    private String editorType = "simditor";
    private String editorSetting = "{}";
    private String editorHeight = "100%";
    private String editorWidth = "100%";
    private String editorSettingCallback = "";
    private String editorAfterSetting = "";
    protected String modulePath = "";
    private String theme = "";

    public String getEditorType() {
        return this.editorType;
    }

    public void setEditorType(String editorType) {
        this.editorType = editorType;
    }

    public String getEditorHeight() {
        return this.editorHeight;
    }

    public void setEditorHeight(String editorHeight) {
        this.editorHeight = editorHeight;
    }

    public String getEditorWidth() {
        return this.editorWidth;
    }

    public void setEditorWidth(String editorWidth) {
        this.editorWidth = editorWidth;
    }

    public String getEditorSetting() {
        return this.editorSetting;
    }

    public void setEditorSetting(String editorSetting) {
        this.editorSetting = editorSetting;
    }

    public String getEditorSettingCallback() {
        return this.editorSettingCallback;
    }

    public void setEditorSettingCallback(String editorSettingCallback) {
        this.editorSettingCallback = editorSettingCallback;
    }

    public String getEditorAfterSetting() {
        return this.editorAfterSetting;
    }

    public void setEditorAfterSetting(String editorAfterSetting) {
        this.editorAfterSetting = editorAfterSetting;
    }

    public String getModulePath() {
        return this.modulePath;
    }

    public void setModulePath(String modulePath) {
        this.modulePath = modulePath;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    protected int writeTagContent(TagWriter tagWriter) throws BeetlTagException {
        tagWriter.startTag("textarea");
        this.writeDefaultAttributes(tagWriter);
        if (this.editorType.equals("markdown")) {
            this.writeOptionalAttribute(tagWriter, "data-provide", "markdown");
        }
        if (this.editorType.equals("ueditor")) {
            String style = this.getCssStyle();
            style = StringUtils.isEmpty((String)style) ? "width:" + this.editorWidth + ";height:" + this.getEditorHeight() : style + ";width:" + this.editorWidth + ";height:" + this.getEditorHeight();
            this.writeOptionalAttribute(tagWriter, "style", style);
        }
        this.writeOptionalAttribute(tagWriter, "rows", this.getRows());
        this.writeOptionalAttribute(tagWriter, "cols", this.getCols());
        this.writeOptionalAttribute(tagWriter, "onselect", this.getOnselect());
        String value = this.getDisplayString(this.getBoundValue(), this.getPropertyEditor());
        tagWriter.appendValue(this.processFieldValue(this.getName(), value, "textarea"));
        tagWriter.endTag();
        this.writeFragment(tagWriter);
        return this.SKIP_BODY;
    }

    private void writeFragment(TagWriter tagWriter) throws BeetlTagException {
        HashMap<String, Object> rootMap = new HashMap<String, Object>();
        String ctx = (String)this.ctx.globalVar.get("ctxPath");
        String adminPath = ctx + "";
        String staticPath = ctx + "/static";
        rootMap.put("ctx", ctx);
        rootMap.put("adminPath", adminPath);
        rootMap.put("staticPath", staticPath);
        rootMap.put("height", this.editorHeight);
        rootMap.put("width", this.editorWidth);
        rootMap.put("editorSettingCallback", this.editorSettingCallback);
        rootMap.put("editorAfterSetting", this.editorAfterSetting);
        rootMap.put("path", this.getPath());
        rootMap.put("modulePath", this.modulePath);
        rootMap.put("theme", this.theme);
        if (StringUtils.isEmpty((String)this.editorSetting)) {
            this.editorSetting = "{}";
        }
        rootMap.put("editorSetting", this.editorSetting);
        this.editorType = this.editorType.toLowerCase();
        HtmlComponentManager htmlComponentManager = (HtmlComponentManager)SpringContextHolder.getApplicationContext().getBean(HtmlComponentManager.class);
        String fragment = htmlComponentManager.getFragmentComponent(this.editorType + "-editor", rootMap);
        if (!StringUtils.isEmpty((String)fragment) && !fragment.equals("null")) {
            tagWriter.forceAppendValue(fragment);
        }
    }
}

