/*
 * Decompiled with CFR 0.152.
 */
package cn.jeeweb.common.mybatis.mvc.wrapper;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.entity.Column;
import com.baomidou.mybatisplus.enums.SqlLike;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.toolkit.MapUtils;
import com.baomidou.mybatisplus.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EntityWrapper<T>
extends Wrapper<T> {
    private static final String PLACE_HOLDER = "{%s}";
    protected T entity = null;
    private String tableAlias = "";
    protected Class<T> entityClass;
    private Map<String, String> attrFieldMap;

    public EntityWrapper() {
    }

    public EntityWrapper(Class<T> entityClass) {
        this.entityClass = entityClass;
        this.initFieldMap();
    }

    public EntityWrapper(T entity) {
        this.entity = entity;
    }

    public EntityWrapper(T entity, String sqlSelect) {
        this.entity = entity;
        this.sqlSelect = sqlSelect;
    }

    public void initFieldMap() {
        if (this.entityClass == null) {
            this.entityClass = this.getTClass();
            this.initFieldMap();
        }
        this.attrFieldMap = new HashMap<String, String>();
        List<Field> allField = EntityWrapper.getAllFields(this.entityClass);
        for (Field field : allField) {
            String columnName;
            String fieldName;
            TableField tableField = field.getAnnotation(TableField.class);
            if (tableField != null) {
                fieldName = field.getName();
                if (StringUtils.isNotEmpty((CharSequence)tableField.el())) {
                    fieldName = tableField.el();
                }
                if (!StringUtils.isNotEmpty((CharSequence)tableField.value())) continue;
                columnName = tableField.value();
                this.attrFieldMap.put(fieldName, columnName);
                continue;
            }
            fieldName = field.getName();
            columnName = StringUtils.camelToUnderline((String)fieldName);
            this.attrFieldMap.put(fieldName, columnName);
        }
    }

    public T getEntity() {
        return this.entity;
    }

    public void setEntity(T entity) {
        this.entity = entity;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public void setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias;
    }

    public String getSqlSegment() {
        String sqlWhere = this.sql.toString();
        if (StringUtils.isEmpty((CharSequence)sqlWhere)) {
            return null;
        }
        String sqlSegment = this.isWhere != null ? (this.isWhere.booleanValue() ? sqlWhere : sqlWhere.replaceFirst("WHERE", this.AND_OR)) : sqlWhere.replaceFirst("WHERE", this.AND_OR);
        return sqlSegment;
    }

    private String handleColumn(String column) {
        if (this.attrFieldMap != null && this.attrFieldMap.containsKey(column)) {
            column = this.attrFieldMap.get(column);
        }
        if (!(column == null || column.contains(".") || column.trim().equals("1") || StringUtils.isEmpty((CharSequence)this.tableAlias))) {
            column = this.tableAlias + "." + column;
        }
        return column;
    }

    public Wrapper<T> eq(boolean condition, String column, Object params) {
        return super.eq(condition, this.handleColumn(column), params);
    }

    public Wrapper<T> eq(String column, Object params) {
        return super.eq(this.handleColumn(column), params);
    }

    public Wrapper<T> ne(boolean condition, String column, Object params) {
        return super.ne(condition, this.handleColumn(column), params);
    }

    public Wrapper<T> ne(String column, Object params) {
        return super.ne(this.handleColumn(column), params);
    }

    public Wrapper<T> allEq(boolean condition, Map<String, Object> params) {
        if (condition && MapUtils.isNotEmpty(params)) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                Object value = entry.getValue();
                if (!StringUtils.checkValNotNull((Object)value)) continue;
                String column = this.handleColumn(entry.getKey());
                this.sql.WHERE(this.formatSql(String.format("%s = {0}", column, entry.getValue()), new Object[0]));
            }
        }
        return this;
    }

    public Wrapper<T> allEq(Map<String, Object> params) {
        return this.allEq(true, params);
    }

    public Wrapper<T> gt(boolean condition, String column, Object params) {
        return super.gt(condition, this.handleColumn(column), params);
    }

    public Wrapper<T> gt(String column, Object params) {
        return super.gt(this.handleColumn(column), params);
    }

    public Wrapper<T> ge(boolean condition, String column, Object params) {
        return super.ge(condition, this.handleColumn(column), params);
    }

    public Wrapper<T> ge(String column, Object params) {
        return super.ge(this.handleColumn(column), params);
    }

    public Wrapper<T> lt(boolean condition, String column, Object params) {
        return super.lt(condition, this.handleColumn(column), params);
    }

    public Wrapper<T> lt(String column, Object params) {
        return super.lt(this.handleColumn(column), params);
    }

    public Wrapper<T> le(boolean condition, String column, Object params) {
        return super.le(condition, this.handleColumn(column), params);
    }

    public Wrapper<T> le(String column, Object params) {
        return super.le(this.handleColumn(column), params);
    }

    public Wrapper<T> like(boolean condition, String column, String value) {
        return super.like(condition, this.handleColumn(column), value);
    }

    public Wrapper<T> like(String column, String value) {
        return super.like(this.handleColumn(column), value);
    }

    public Wrapper<T> notLike(boolean condition, String column, String value) {
        return super.like(condition, this.handleColumn(column), value);
    }

    public Wrapper<T> notLike(String column, String value) {
        return super.notLike(this.handleColumn(column), value);
    }

    public Wrapper<T> like(boolean condition, String column, String value, SqlLike type) {
        return super.like(condition, this.handleColumn(column), value);
    }

    public Wrapper<T> like(String column, String value, SqlLike type) {
        return super.like(this.handleColumn(column), value, type);
    }

    public Wrapper<T> notLike(boolean condition, String column, String value, SqlLike type) {
        return super.notLike(condition, this.handleColumn(column), value, type);
    }

    public Wrapper<T> notLike(String column, String value, SqlLike type) {
        return super.notLike(this.handleColumn(column), value, type);
    }

    public Wrapper<T> isNotNull(boolean condition, String columns) {
        if (columns == null) {
            return super.isNotNull(condition, columns);
        }
        String[] columnArr = columns.split(",");
        String columnNews = "";
        for (String column : columnArr) {
            if (!columnNews.isEmpty()) {
                columnNews = columnNews + ",";
            }
            columnNews = columnNews + this.handleColumn(column);
        }
        return super.isNotNull(condition, columnNews);
    }

    public Wrapper<T> isNotNull(String columns) {
        return this.isNotNull(true, columns);
    }

    public Wrapper<T> isNull(boolean condition, String columns) {
        String[] columnArr = columns.split(",");
        String columnNews = "";
        for (String column : columnArr) {
            if (!columnNews.isEmpty()) {
                columnNews = columnNews + ",";
            }
            columnNews = columnNews + this.handleColumn(column);
        }
        return super.isNull(condition, columnNews);
    }

    public Wrapper<T> isNull(String columns) {
        return this.isNull(true, columns);
    }

    public Wrapper<T> in(boolean condition, String column, String value) {
        if (condition && StringUtils.isNotEmpty((CharSequence)value)) {
            this.in(column, StringUtils.splitWorker((String)value, (String)",", (int)-1, (boolean)false));
        }
        return this;
    }

    public Wrapper<T> in(String column, String value) {
        return this.in(true, column, value);
    }

    public Wrapper<T> notIn(boolean condition, String column, String value) {
        if (condition && StringUtils.isNotEmpty((CharSequence)value)) {
            this.notIn(column, StringUtils.splitWorker((String)value, (String)",", (int)-1, (boolean)false));
        }
        return this;
    }

    public Wrapper<T> notIn(String column, String value) {
        return this.notIn(true, column, value);
    }

    public Wrapper<T> in(boolean condition, String column, Collection<?> value) {
        if (condition && CollectionUtils.isNotEmpty(value)) {
            this.sql.WHERE(this.formatSql(this.inExpression(column, value, false), value.toArray()));
        }
        return this;
    }

    public Wrapper<T> in(String column, Collection<?> value) {
        return this.in(true, column, value);
    }

    public Wrapper<T> notIn(boolean condition, String column, Collection<?> value) {
        if (condition && CollectionUtils.isNotEmpty(value)) {
            this.sql.WHERE(this.formatSql(this.inExpression(column, value, true), value.toArray()));
        }
        return this;
    }

    public Wrapper<T> notIn(String column, Collection<?> value) {
        return this.notIn(true, column, value);
    }

    public Wrapper<T> in(boolean condition, String column, Object[] value) {
        if (condition && ArrayUtils.isNotEmpty((Object[])value)) {
            this.sql.WHERE(this.formatSql(this.inExpression(column, Arrays.asList(value), false), value));
        }
        return this;
    }

    public Wrapper<T> in(String column, Object[] value) {
        return this.in(true, column, value);
    }

    public Wrapper<T> notIn(boolean condition, String column, Object ... value) {
        if (condition && ArrayUtils.isNotEmpty((Object[])value)) {
            this.sql.WHERE(this.formatSql(this.inExpression(column, Arrays.asList(value), true), value));
        }
        return this;
    }

    public Wrapper<T> notIn(String column, Object ... value) {
        return this.notIn(true, column, value);
    }

    private String inExpression(String column, Collection<?> value, boolean isNot) {
        if (StringUtils.isNotEmpty((CharSequence)(column = this.handleColumn(column))) && CollectionUtils.isNotEmpty(value)) {
            StringBuilder inSql = new StringBuilder();
            inSql.append(column);
            if (isNot) {
                inSql.append(" NOT");
            }
            inSql.append(" IN ");
            inSql.append("(");
            int size = value.size();
            for (int i = 0; i < size; ++i) {
                inSql.append(String.format(PLACE_HOLDER, i));
                if (i + 1 >= size) continue;
                inSql.append(",");
            }
            inSql.append(")");
            return inSql.toString();
        }
        return null;
    }

    public Wrapper<T> between(boolean condition, String column, Object val1, Object val2) {
        return super.between(condition, this.handleColumn(column), val1, val2);
    }

    public Wrapper<T> between(String column, Object val1, Object val2) {
        return super.between(this.handleColumn(column), val1, val2);
    }

    public Wrapper<T> notBetween(boolean condition, String column, Object val1, Object val2) {
        return super.notBetween(condition, this.handleColumn(column), val1, val2);
    }

    public Wrapper<T> notBetween(String column, Object val1, Object val2) {
        return super.notBetween(this.handleColumn(column), val1, val2);
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        List fieldList = ReflectionKit.getFieldList(clazz);
        if (CollectionUtils.isNotEmpty((Collection)fieldList)) {
            Iterator iterator = fieldList.iterator();
            while (iterator.hasNext()) {
                Field field = (Field)iterator.next();
                TableField tableField = field.getAnnotation(TableField.class);
                if (tableField == null || tableField.exist()) continue;
                iterator.remove();
            }
        }
        return fieldList;
    }

    public Wrapper<T> setSqlSelect(Column ... column) {
        if (ArrayUtils.isNotEmpty((Object[])column)) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < column.length; ++i) {
                if (column[i] == null) continue;
                String col = column[i].getColumn();
                String as = column[i].getAs();
                if (StringUtils.isEmpty((CharSequence)col)) continue;
                builder.append(col).append(as);
                if (i >= column.length - 1) continue;
                builder.append(",");
            }
            this.sqlSelect = builder.toString();
        }
        return this;
    }

    public Class<T> getTClass() {
        Class tClass = (Class)((ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return tClass;
    }

    public Wrapper<T> orderBy(String columns, boolean isAsc) {
        return this.orderBy(true, columns, isAsc);
    }

    public Wrapper<T> orderBy(boolean condition, String columns) {
        if (columns == null) {
            return super.orderBy(condition, columns);
        }
        String[] columnArr = columns.split(",");
        String columnNews = "";
        for (String column : columnArr) {
            if (!columnNews.isEmpty()) {
                columnNews = columnNews + ",";
            }
            columnNews = columnNews + this.handleColumn(column);
        }
        return super.orderBy(condition, columnNews);
    }

    public Wrapper<T> orderBy(boolean condition, String columns, boolean isAsc) {
        if (columns == null) {
            return super.orderBy(condition, columns, isAsc);
        }
        String[] columnArr = columns.split(",");
        String columnNews = "";
        for (String column : columnArr) {
            if (!columnNews.isEmpty()) {
                columnNews = columnNews + ",";
            }
            columnNews = columnNews + this.handleColumn(column);
        }
        return super.orderBy(condition, columnNews, isAsc);
    }

    public Wrapper<T> orderBy(String columns) {
        if (columns == null) {
            return super.orderBy(columns);
        }
        String[] columnArr = columns.split(",");
        String columnNews = "";
        for (String column : columnArr) {
            if (!columnNews.isEmpty()) {
                columnNews = columnNews + ",";
            }
            columnNews = columnNews + this.handleColumn(column);
        }
        return super.orderBy(columnNews);
    }
}

