/*
 * Decompiled with CFR 0.152.
 */
package cn.jeeweb.common.mybatis.mvc.service.impl;

import cn.jeeweb.common.mvc.entity.tree.TreeNode;
import cn.jeeweb.common.mybatis.mvc.mapper.BaseTreeMapper;
import cn.jeeweb.common.mybatis.mvc.parse.QueryToWrapper;
import cn.jeeweb.common.mybatis.mvc.service.ITreeCommonService;
import cn.jeeweb.common.mybatis.mvc.service.impl.CommonServiceImpl;
import cn.jeeweb.common.query.data.Queryable;
import cn.jeeweb.common.utils.ObjectUtils;
import com.baomidou.mybatisplus.mapper.Wrapper;
import java.io.Serializable;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class TreeCommonServiceImpl<M extends BaseTreeMapper<T>, T extends Serializable & TreeNode<ID>, ID extends Serializable>
extends CommonServiceImpl<M, T>
implements ITreeCommonService<T, ID> {
    public T selectById(Serializable id) {
        return (T)((Serializable)((BaseTreeMapper)this.baseMapper).selectByTreeId(id));
    }

    @Override
    public List<T> selectTreeList(Queryable queryable, Wrapper<T> wrapper) {
        QueryToWrapper<T> queryToWrapper = new QueryToWrapper<T>();
        wrapper.eq("1", (Object)"1");
        queryToWrapper.parseCondition(wrapper, queryable);
        queryToWrapper.parseSort(wrapper, queryable);
        List<T> content = ((BaseTreeMapper)this.baseMapper).selectTreeList(wrapper);
        return content;
    }

    @Override
    public List<T> selectTreeList(Wrapper<T> wrapper) {
        wrapper.eq("1", (Object)"1");
        List<T> content = ((BaseTreeMapper)this.baseMapper).selectTreeList(wrapper);
        return content;
    }

    public boolean insert(T entity) {
        if (!ObjectUtils.isNullOrEmpty((Object)((TreeNode)entity).getParentId())) {
            Object parent = this.selectById((Serializable)((TreeNode)entity).getParentId());
            ((TreeNode)entity).setParentId(((TreeNode)parent).getId());
            ((TreeNode)entity).setParentIds(((TreeNode)parent).makeSelfAsNewParentIds());
        } else {
            ((TreeNode)entity).setParentId(null);
        }
        return super.insert(entity);
    }

    public boolean insertOrUpdate(T entity) {
        if (!ObjectUtils.isNullOrEmpty((Object)((TreeNode)entity).getParentId())) {
            Object parent = this.selectById((Serializable)((TreeNode)entity).getParentId());
            this.updateSelftAndChild(entity, (Serializable)((TreeNode)parent).getId(), ((TreeNode)parent).makeSelfAsNewParentIds());
        } else {
            ((TreeNode)entity).setParentId(null);
            this.updateSelftAndChild(entity, null, null);
        }
        return true;
    }

    private void updateSelftAndChild(T entity, ID newParentId, String newParentIds) {
        Object oldEntity = this.selectById((Serializable)((TreeNode)entity).getId());
        String oldChildrenParentIds = ((TreeNode)oldEntity).makeSelfAsNewParentIds();
        ((TreeNode)entity).setParentId(newParentId);
        ((TreeNode)entity).setParentIds(newParentIds);
        super.insertOrUpdate(entity);
        String newChildrenParentIds = ((TreeNode)entity).makeSelfAsNewParentIds();
        ((BaseTreeMapper)this.baseMapper).updateSunTreeParentIds(newChildrenParentIds, oldChildrenParentIds);
    }
}

