/*
 * Decompiled with CFR 0.152.
 */
package cn.jeeweb.common.mybatis.mvc.parse;

import cn.jeeweb.common.query.data.Condition;
import cn.jeeweb.common.query.data.Queryable;
import cn.jeeweb.common.query.data.Sort;
import cn.jeeweb.common.utils.ObjectUtils;
import com.baomidou.mybatisplus.mapper.Wrapper;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;

public class QueryToWrapper<T> {
    public void parseCondition(Wrapper<T> wrapper, Queryable queryable) {
        Condition condition = queryable.getCondition();
        if (condition != null) {
            for (Condition.Filter filter : condition) {
                Object value = filter.getValue();
                if (ObjectUtils.isNullOrEmpty((Object)value)) continue;
                Condition.Operator operator = filter.getOperator();
                String property = filter.getProperty();
                if (operator == Condition.Operator.custom) continue;
                if (operator == Condition.Operator.isNull) {
                    wrapper.isNull(property);
                    continue;
                }
                if (operator == Condition.Operator.isNotNull) {
                    wrapper.isNotNull(property);
                    continue;
                }
                if (operator == Condition.Operator.between) {
                    Object[] between = null;
                    between = value instanceof List ? ((List)value).toArray(new Object[((List)value).size()]) : (Object[])value;
                    if (between.length != 2) continue;
                    wrapper.between(property, between[0], between[1]);
                    continue;
                }
                if (operator.name().toUpperCase(Locale.US).contains("LIKE")) {
                    value = this.parseLike(filter);
                    if (operator.name().contains("NOT")) {
                        wrapper.notLike(filter.getProperty(), (String)value);
                        continue;
                    }
                    wrapper.like(filter.getProperty(), (String)value);
                    continue;
                }
                this.invokeWrapper(wrapper, filter);
            }
        }
    }

    public Object parseLike(Condition.Filter filter) {
        String operatorStr = filter.getOperator().name().toUpperCase(Locale.US);
        Object value = filter.getValue();
        value = operatorStr.contains("PREFIX") ? "%" + value : (operatorStr.contains("SUFFIX") ? value + "%" : "%" + value + "%");
        return value;
    }

    public void invokeWrapper(Wrapper<T> wrapper, Condition.Filter filter) {
        try {
            Method method = wrapper.getClass().getMethod(filter.getOperator().name(), String.class, Object.class);
            method.invoke(wrapper, filter.getProperty(), filter.getValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parseSort(Wrapper<T> wrapper, Queryable queryable) {
        Sort sort = queryable.getPageable().getSort();
        if (sort != null) {
            for (Sort.Order order : sort) {
                if (order.getDirection() == Sort.Direction.DESC) {
                    wrapper.orderBy(order.getProperty(), false);
                    continue;
                }
                if (order.getDirection() != Sort.Direction.ASC) continue;
                wrapper.orderBy(order.getProperty(), true);
            }
        }
    }
}

