/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.tompuss.util;

import java.beans.ConstructorProperties;

public class TPUrlPattern {
    private String pattern;
    private Type type;

    public TPUrlPattern(String path) {
        if (path.endsWith("/*")) {
            this.type = Type.PREFIX;
            this.pattern = path.substring(0, path.length() - 2);
        } else if (path.startsWith("*.")) {
            this.type = Type.SUFFIX;
            this.pattern = path.substring(1);
        } else if (path.equals("/") || path.isEmpty()) {
            this.type = Type.DEFAULT;
            this.pattern = "";
        } else {
            this.type = Type.EXACT;
            this.pattern = path;
        }
    }

    public Match match(String path) {
        boolean matches = false;
        String matched = "";
        switch (this.type) {
            case EXACT: {
                matches = this.pattern.equals(path);
                matched = this.pattern;
                break;
            }
            case PREFIX: {
                matches = path.startsWith(this.pattern);
                matched = this.pattern;
                break;
            }
            case SUFFIX: {
                matches = path.endsWith(this.pattern);
                matched = path;
                break;
            }
            case DEFAULT: {
                matches = true;
            }
        }
        if (matches) {
            return new Match(this.type, this.pattern.length(), matched);
        }
        return Match.NO_MATCH;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TPUrlPattern)) {
            return false;
        }
        TPUrlPattern other = (TPUrlPattern)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TPUrlPattern;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public static class Match
    implements Comparable<Match> {
        public static final Match NO_MATCH = new Match(Type.DEFAULT, -1, "");
        private Type patternType;
        private int patternLength;
        private String matched;

        @Override
        public int compareTo(Match other) {
            if (this.patternType.priority > other.patternType.priority) {
                return 1;
            }
            if (this.patternType.priority == other.patternType.priority && this.patternLength > other.patternLength) {
                return 1;
            }
            return -1;
        }

        public Type getPatternType() {
            return this.patternType;
        }

        public int getPatternLength() {
            return this.patternLength;
        }

        public String getMatched() {
            return this.matched;
        }

        @ConstructorProperties(value={"patternType", "patternLength", "matched"})
        public Match(Type patternType, int patternLength, String matched) {
            this.patternType = patternType;
            this.patternLength = patternLength;
            this.matched = matched;
        }
    }

    public static enum Type {
        DEFAULT(0),
        SUFFIX(10),
        PREFIX(20),
        EXACT(90);

        private int priority;

        public int getPriority() {
            return this.priority;
        }

        @ConstructorProperties(value={"priority"})
        private Type(int priority) {
            this.priority = priority;
        }
    }
}

