/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.tompuss.session;

import cn.imaq.tompuss.servlet.TPServletContext;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionContext;

public class TPHttpSession
implements HttpSession {
    private TPServletContext context;
    private String sessId;
    private long created;
    private long lastAccess;
    private int timeout;
    private volatile boolean invalidated;
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    TPHttpSession(TPServletContext context, String sessId) {
        this.context = context;
        this.sessId = sessId;
        this.lastAccess = this.created = System.currentTimeMillis();
        this.timeout = context.getSessionTimeout();
    }

    public long getCreationTime() {
        this.checkValid();
        return this.created;
    }

    public String getId() {
        return this.sessId;
    }

    public long getLastAccessedTime() {
        this.checkValid();
        return this.lastAccess;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public void setMaxInactiveInterval(int interval) {
        this.timeout = interval;
    }

    public int getMaxInactiveInterval() {
        return this.timeout;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getAttribute(String name) {
        this.checkValid();
        this.updateLastAccess();
        return this.attributes.get(name);
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        this.checkValid();
        this.updateLastAccess();
        return Collections.enumeration(this.attributes.keySet());
    }

    public String[] getValueNames() {
        this.checkValid();
        this.updateLastAccess();
        return this.attributes.keySet().toArray(new String[0]);
    }

    public void setAttribute(String name, Object value) {
        this.checkValid();
        this.updateLastAccess();
        if (this.attributes.put(name, value) == null) {
            this.context.getListeners(HttpSessionAttributeListener.class).forEach(x -> x.attributeAdded(new HttpSessionBindingEvent((HttpSession)this, name, value)));
        } else {
            this.context.getListeners(HttpSessionAttributeListener.class).forEach(x -> x.attributeReplaced(new HttpSessionBindingEvent((HttpSession)this, name, value)));
        }
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.checkValid();
        this.updateLastAccess();
        this.attributes.remove(name);
        this.context.getListeners(HttpSessionAttributeListener.class).forEach(x -> x.attributeRemoved(new HttpSessionBindingEvent((HttpSession)this, name)));
    }

    public void removeValue(String name) {
        this.checkValid();
        this.removeAttribute(name);
    }

    public void invalidate() {
        this.checkValid();
        this.invalidated = true;
    }

    public boolean isNew() {
        return this.lastAccess == this.created;
    }

    private void updateLastAccess() {
        this.lastAccess = System.currentTimeMillis();
    }

    public boolean isValid() {
        if (this.invalidated || this.timeout < 0) {
            return false;
        }
        if (this.timeout == 0) {
            return true;
        }
        return this.lastAccess + (long)(this.timeout * 60000) > System.currentTimeMillis();
    }

    public void checkValid() {
        if (!this.isValid()) {
            throw new IllegalStateException();
        }
    }
}

