/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.tompuss.filter;

import cn.imaq.tompuss.core.TPRegistration;
import cn.imaq.tompuss.filter.TPFilterMapping;
import cn.imaq.tompuss.servlet.TPServletContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.GenericFilter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPFilterRegistration
extends TPRegistration<Filter>
implements FilterRegistration.Dynamic {
    private static final Logger log = LoggerFactory.getLogger(TPFilterRegistration.class);
    private Set<String> servletMappings = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<String> urlPatternMappings = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile boolean init = false;

    public TPFilterRegistration(TPServletContext context, String name, Filter instance) {
        super(context, name, instance);
    }

    public void loadAnnotation(WebFilter wf) {
        EnumSet<DispatcherType> dispatcherTypes = wf.dispatcherTypes().length > 0 ? EnumSet.copyOf(Arrays.asList(wf.dispatcherTypes())) : EnumSet.allOf(DispatcherType.class);
        if (wf.value().length > 0) {
            this.addMappingForUrlPatterns(dispatcherTypes, true, wf.value());
        }
        if (wf.urlPatterns().length > 0) {
            this.addMappingForUrlPatterns(dispatcherTypes, true, wf.urlPatterns());
        }
        if (wf.servletNames().length > 0) {
            this.addMappingForServletNames(dispatcherTypes, true, wf.servletNames());
        }
        this.setAsyncSupported(wf.asyncSupported());
        for (WebInitParam initParam : wf.initParams()) {
            this.setInitParameter(initParam.name(), initParam.value());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter getFilterInstance() {
        if (!this.init) {
            if (this.instance instanceof GenericFilter && ((GenericFilter)this.instance).getFilterConfig() != null) {
                this.init = true;
            } else {
                TPFilterRegistration tPFilterRegistration = this;
                synchronized (tPFilterRegistration) {
                    if (!this.init) {
                        log.info("Initiating Filter {}[{}]", (Object)this.name, (Object)((Filter)this.instance).getClass().getName());
                        FilterConfig config = new FilterConfig(){

                            public String getFilterName() {
                                return TPFilterRegistration.this.name;
                            }

                            public ServletContext getServletContext() {
                                return TPFilterRegistration.this.context;
                            }

                            public String getInitParameter(String name) {
                                return TPFilterRegistration.this.getInitParameter(name);
                            }

                            public Enumeration<String> getInitParameterNames() {
                                return Collections.enumeration(TPFilterRegistration.this.getInitParameters().keySet());
                            }
                        };
                        try {
                            ((Filter)this.instance).init(config);
                            this.init = true;
                        }
                        catch (ServletException e) {
                            log.error("Error initiating Filter {}[{}]: {}", new Object[]{this.name, ((Filter)this.instance).getClass().getName(), e});
                        }
                    }
                }
            }
        }
        return (Filter)this.instance;
    }

    public void addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
        if (servletNames == null || servletNames.length == 0) {
            throw new IllegalArgumentException();
        }
        this.context.addFilterMapping(new TPFilterMapping.ByServlet(this, dispatcherTypes, servletNames), isMatchAfter);
        this.servletMappings.addAll(Arrays.asList(servletNames));
    }

    public Collection<String> getServletNameMappings() {
        return Collections.unmodifiableCollection(this.servletMappings);
    }

    public void addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) {
        if (urlPatterns == null || urlPatterns.length == 0) {
            throw new IllegalArgumentException();
        }
        this.context.addFilterMapping(new TPFilterMapping.ByUrlPattern(this, dispatcherTypes, urlPatterns), isMatchAfter);
        this.urlPatternMappings.addAll(Arrays.asList(urlPatterns));
    }

    public Collection<String> getUrlPatternMappings() {
        return Collections.unmodifiableCollection(this.urlPatternMappings);
    }
}

