/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.tompuss.dispatcher;

import cn.imaq.tompuss.servlet.TPHttpServletRequest;
import cn.imaq.tompuss.servlet.TPServletContext;
import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TPRequestDispatcher
implements RequestDispatcher {
    private static final Logger log = LoggerFactory.getLogger(TPRequestDispatcher.class);
    protected TPServletContext context;

    TPRequestDispatcher(TPServletContext context) {
        this.context = context;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (request instanceof TPHttpServletRequest) {
            TPHttpServletRequest httpServletRequest = (TPHttpServletRequest)request;
            httpServletRequest.setDispatcherType(DispatcherType.FORWARD);
            httpServletRequest.setAttribute("javax.servlet.forward.request_uri", httpServletRequest.getRequestURI());
            httpServletRequest.setAttribute("javax.servlet.forward.context_path", httpServletRequest.getContextPath());
            httpServletRequest.setAttribute("javax.servlet.forward.path_info", httpServletRequest.getPathInfo());
            httpServletRequest.setAttribute("javax.servlet.forward.servlet_path", httpServletRequest.getServletPath());
            httpServletRequest.setAttribute("javax.servlet.forward.query_string", httpServletRequest.getQueryString());
        }
        response.resetBuffer();
        this.dispatch(request, response);
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (request instanceof TPHttpServletRequest) {
            TPHttpServletRequest httpServletRequest = (TPHttpServletRequest)request;
            httpServletRequest.setDispatcherType(DispatcherType.INCLUDE);
            httpServletRequest.setAttribute("javax.servlet.include.request_uri", httpServletRequest.getRequestURI());
            httpServletRequest.setAttribute("javax.servlet.include.context_path", httpServletRequest.getContextPath());
            httpServletRequest.setAttribute("javax.servlet.include.path_info", httpServletRequest.getPathInfo());
            httpServletRequest.setAttribute("javax.servlet.include.servlet_path", httpServletRequest.getServletPath());
            httpServletRequest.setAttribute("javax.servlet.include.query_string", httpServletRequest.getQueryString());
        }
        this.dispatch(request, response);
    }

    public void request(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.dispatch(request, response);
    }

    protected abstract void dispatch(ServletRequest var1, ServletResponse var2) throws ServletException, IOException;
}

