/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.tompuss.util;

import cn.imaq.tompuss.filter.TPFilterRegistration;
import cn.imaq.tompuss.servlet.TPServletContext;
import cn.imaq.tompuss.servlet.TPServletRegistration;
import java.io.File;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletRegistration;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPXmlUtil {
    private static final Logger log = LoggerFactory.getLogger(TPXmlUtil.class);

    public static void parseWebXml(TPServletContext context, File xmlFile) {
        log.info("Loading XML config file {}", (Object)xmlFile);
        try {
            Element root = new SAXReader().read(xmlFile).getRootElement();
            block18: for (Element element : root.elements()) {
                switch (element.getName()) {
                    case "context-param": {
                        context.setInitParameter(element.elementTextTrim("param-name"), element.elementText("param-value"));
                        break;
                    }
                    case "servlet": {
                        Element asyncSupported;
                        TPServletRegistration sRegDyn = context.addServlet(element.elementTextTrim("servlet-name"), element.elementTextTrim("servlet-class"));
                        for (Element initParam : element.elements("init-param")) {
                            sRegDyn.setInitParameter(initParam.elementTextTrim("param-name"), initParam.elementText("param-value"));
                        }
                        Element loadOnStartup = element.element("load-on-startup");
                        if (loadOnStartup != null) {
                            sRegDyn.setLoadOnStartup(Integer.parseInt(loadOnStartup.getTextTrim()));
                        }
                        if ((asyncSupported = element.element("async-supported")) == null) break;
                        sRegDyn.setAsyncSupported(asyncSupported.getTextTrim().equals("true"));
                        break;
                    }
                    case "servlet-mapping": {
                        ServletRegistration sReg = context.getServletRegistration(element.elementTextTrim("servlet-name"));
                        if (sReg == null) break;
                        sReg.addMapping((String[])element.elements("url-pattern").stream().map(Element::getTextTrim).toArray(String[]::new));
                        break;
                    }
                    case "filter": {
                        TPFilterRegistration fRegDyn = context.addFilter(element.elementTextTrim("filter-name"), element.elementTextTrim("filter-class"));
                        for (Element initParam : element.elements("init-param")) {
                            fRegDyn.setInitParameter(initParam.elementTextTrim("param-name"), initParam.elementText("param-value"));
                        }
                        Element asyncSupported = element.element("async-supported");
                        if (asyncSupported == null) break;
                        fRegDyn.setAsyncSupported(asyncSupported.getTextTrim().equals("true"));
                        break;
                    }
                    case "filter-mapping": {
                        FilterRegistration fReg = context.getFilterRegistration(element.elementTextTrim("filter-name"));
                        if (fReg == null) break;
                        Set dispatcherTypeSet = element.elements("dispatcher").stream().map(e -> DispatcherType.valueOf((String)e.getTextTrim())).collect(Collectors.toSet());
                        EnumSet<Object> dispatcherTypes = dispatcherTypeSet.isEmpty() ? EnumSet.allOf(DispatcherType.class) : EnumSet.copyOf(dispatcherTypeSet);
                        if (dispatcherTypes.isEmpty()) {
                            dispatcherTypes = EnumSet.of(DispatcherType.REQUEST);
                        }
                        String[] servletNames = (String[])element.elements("servlet-name").stream().map(Element::getTextTrim).toArray(String[]::new);
                        String[] urlPatterns = (String[])element.elements("url-pattern").stream().map(Element::getTextTrim).toArray(String[]::new);
                        if (servletNames.length > 0) {
                            fReg.addMappingForServletNames(dispatcherTypes, true, servletNames);
                        }
                        if (urlPatterns.length <= 0) continue block18;
                        fReg.addMappingForUrlPatterns(dispatcherTypes, true, urlPatterns);
                        break;
                    }
                    case "listener": {
                        context.addListener(element.elementTextTrim("listener-class"));
                    }
                }
            }
        }
        catch (Exception e2) {
            log.warn("Load XML config failed: {}", (Object)String.valueOf(e2));
        }
    }
}

