/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.tompuss.servlet;

import cn.imaq.autumn.http.protocol.AutumnHttpResponse;
import cn.imaq.tompuss.io.TPOutputStream;
import cn.imaq.tompuss.servlet.TPHttpExchange;
import cn.imaq.tompuss.servlet.TPServletContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class TPHttpServletResponse
implements HttpServletResponse {
    private TPServletContext context;
    private TPHttpExchange exchange;
    private int status;
    private String contentType;
    private Map<String, List<String>> headers;
    private TPOutputStream outputStream;
    private PrintWriter writer;
    private int bufferSize = 32;
    private Locale locale;
    private String encoding;
    private byte[] body;

    public TPHttpServletResponse(TPServletContext context, TPHttpExchange exchange) {
        this.reset();
        this.context = context;
        this.exchange = exchange;
    }

    public AutumnHttpResponse toAutumnHttpResponse() {
        if (this.body == null) {
            if (this.writer != null) {
                this.writer.flush();
            }
            if (this.outputStream != null) {
                this.body = this.outputStream.toByteArray();
            }
        }
        if (this.contentType != null) {
            this.setHeader("Content-Type", this.contentType + ";charset=" + this.getCharacterEncoding());
        }
        if (this.locale != null) {
            this.setHeader("Content-Language", this.locale.toLanguageTag());
        }
        for (Cookie cookie : this.exchange.getCookies()) {
            this.addCookie(cookie);
        }
        return AutumnHttpResponse.builder().status(this.status).headers(this.headers).body(this.body).build();
    }

    public void addCookie(Cookie cookie) {
        StringBuilder sb = new StringBuilder();
        sb.append(cookie.getName()).append('=').append(cookie.getValue());
        if (cookie.getComment() != null) {
            sb.append(";Comment=").append(cookie.getDomain());
        }
        if (cookie.getDomain() != null) {
            sb.append(";Domain=").append(cookie.getDomain());
        }
        if (cookie.getMaxAge() > 0) {
            sb.append(";Max-Age=").append(cookie.getMaxAge());
        }
        if (cookie.getPath() != null) {
            sb.append(";Path=").append(cookie.getPath());
        }
        if (cookie.getSecure()) {
            sb.append(";Secure");
        }
        if (cookie.isHttpOnly()) {
            sb.append(";HttpOnly");
        }
        this.addHeader("Set-Cookie", sb.toString());
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.setStatus(sc);
        this.setContentType("text/html");
        this.resetBuffer();
        this.getOutputStream().print(msg);
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, "<html><head><title>Error</title></head><body><center><h1>" + sc + " " + AutumnHttpResponse.ResponseCodes.get((int)sc) + "</h1></center><hr><center>TomPuss</center></body></html>");
    }

    public void sendRedirect(String location) throws IOException {
        while (location.length() > 1 && location.endsWith("/")) {
            location = location.substring(0, location.length() - 1);
        }
        this.reset();
        this.setStatus(302);
        this.setHeader("Location", location);
    }

    public void setDateHeader(String name, long date) {
        this.setHeader(name, new SimpleDateFormat("EEE dd MMM yyyy HH:mm:ss z").format(new Date(date)));
    }

    public void addDateHeader(String name, long date) {
        this.addHeader(name, new SimpleDateFormat("EEE dd MMM yyyy HH:mm:ss z").format(new Date(date)));
    }

    public void setHeader(String name, final String value) {
        this.headers.put(name, (List<String>)new ArrayList<String>(){
            {
                this.add(value);
            }
        });
    }

    public void addHeader(String name, String value) {
        this.headers.computeIfAbsent(name, x -> new ArrayList()).add(value);
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, Integer.toString(value));
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, Integer.toString(value));
    }

    public void setStatus(int sc) {
        this.status = sc;
    }

    public void setStatus(int sc, String sm) {
        try {
            this.sendError(sc, sm);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getStatus() {
        return this.status;
    }

    public String getHeader(String name) {
        if (!this.containsHeader(name)) {
            return null;
        }
        return this.headers.get(name).get(0);
    }

    public Collection<String> getHeaders(String name) {
        if (!this.containsHeader(name)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection((Collection)this.headers.get(name));
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public String getCharacterEncoding() {
        if (this.encoding == null) {
            this.encoding = this.context.getResponseCharacterEncoding();
        }
        return this.encoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new TPOutputStream(this.bufferSize);
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), this.getCharacterEncoding()));
        }
        return this.writer;
    }

    public void setCharacterEncoding(String charset) {
        this.encoding = charset;
    }

    public void setContentLength(int len) {
    }

    public void setContentLengthLong(long len) {
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public void setBufferSize(int size) {
        if (this.outputStream != null) {
            throw new IllegalStateException();
        }
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void flushBuffer() throws IOException {
        this.outputStream.flush();
    }

    public void resetBuffer() {
        this.outputStream = null;
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
        this.status = 200;
        this.contentType = null;
        this.headers = new HashMap<String, List<String>>();
        this.outputStream = null;
        this.bufferSize = 32;
        this.locale = null;
        this.encoding = null;
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public Locale getLocale() {
        return this.locale == null ? Locale.getDefault() : this.locale;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }
}

