/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.tompuss.servlet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Part;

public class TPFormPart
implements Part {
    private byte[] dataSrc;
    private int offset;
    private int length;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public TPFormPart(byte[] dataSrc) {
        this.dataSrc = dataSrc;
    }

    private String getHeaderParam(String header, String param) {
        if (!this.headers.containsKey(header)) {
            return null;
        }
        String[] dispositions = this.headers.get(header).get(0).split(";");
        for (int i = 1; i < dispositions.length; ++i) {
            String[] nameAndValue = dispositions[i].trim().split("=", 2);
            if (nameAndValue.length != 2 || !nameAndValue[0].equals(param)) continue;
            String value = nameAndValue[1];
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            return value;
        }
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.dataSrc, this.offset, this.length);
    }

    public String getContentType() {
        if (!this.headers.containsKey("content-type")) {
            return "text/plain";
        }
        return this.headers.get("content-type").get(0).split(";", 2)[0];
    }

    public String getName() {
        return this.getHeaderParam("content-disposition", "name");
    }

    public String getSubmittedFileName() {
        return this.getHeaderParam("content-disposition", "filename");
    }

    public long getSize() {
        return this.length;
    }

    public void write(String fileName) throws IOException {
    }

    public void delete() throws IOException {
    }

    public String getHeader(String name) {
        Collection<String> values = this.getHeaders(name);
        if (values == null) {
            return null;
        }
        return values.iterator().next();
    }

    public Collection<String> getHeaders(String name) {
        String lower = name.toLowerCase();
        if (!this.headers.containsKey(lower)) {
            return null;
        }
        return this.headers.get(lower);
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }
}

