/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.tompuss.core;

import cn.imaq.autumn.http.server.AutumnHttpServer;
import cn.imaq.autumn.http.server.protocol.AutumnHttpHandler;
import cn.imaq.tompuss.core.TPDispatcher;
import cn.imaq.tompuss.servlet.TPServletContext;
import cn.imaq.tompuss.util.TPMatchResult;
import java.io.File;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPEngine {
    private static final Logger log = LoggerFactory.getLogger(TPEngine.class);
    private int port;
    private AutumnHttpServer httpServer;
    private Queue<TPServletContext> contexts = new ConcurrentLinkedQueue<TPServletContext>();

    public TPEngine(int port) {
        this.port = port;
    }

    public synchronized void start() {
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
        try {
            this.httpServer = new AutumnHttpServer(this.port, (AutumnHttpHandler)new TPDispatcher(this));
            for (TPServletContext context : this.contexts) {
                context.startup();
            }
            this.httpServer.start();
            log.info("TomPuss Engine started on port {}", (Object)this.port);
        }
        catch (IOException e) {
            log.error("TomPuss Engine failed to start!", (Throwable)e);
        }
    }

    public synchronized void stop() {
        log.info("Stopping TomPuss Engine ...");
        this.httpServer.stop();
    }

    public TPServletContext newWebApp(String appName, String contextPath, File resourceRoot) {
        TPServletContext context = new TPServletContext(this, appName, contextPath, resourceRoot);
        this.contexts.add(context);
        return context;
    }

    public TPMatchResult<TPServletContext> matchContextByPath(String path) {
        TPServletContext result = null;
        int bestLength = 0;
        for (TPServletContext context : this.contexts) {
            String contextPath = context.getContextPath();
            if (!path.startsWith(contextPath) || contextPath.length() <= bestLength) continue;
            bestLength = contextPath.length();
            result = context;
        }
        if (result != null) {
            return new TPMatchResult<TPServletContext>(result.getContextPath(), result);
        }
        return null;
    }

    public TPEngine() {
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

