/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.tompuss.servlet;

import cn.imaq.autumn.http.protocol.AutumnHttpRequest;
import cn.imaq.tompuss.io.TPInputStream;
import cn.imaq.tompuss.io.TPMultipartParser;
import cn.imaq.tompuss.servlet.TPFormPart;
import cn.imaq.tompuss.servlet.TPHttpExchange;
import cn.imaq.tompuss.servlet.TPServletContext;
import cn.imaq.tompuss.session.TPHttpSession;
import cn.imaq.tompuss.session.TPSessionContext;
import cn.imaq.tompuss.util.TPMatchResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;

public class TPHttpServletRequest
implements HttpServletRequest {
    private AutumnHttpRequest httpRequest;
    private TPServletContext context;
    private TPHttpExchange exchange;
    private String encoding = null;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Map<String, String[]> params;
    private Map<String, TPFormPart> formParts;
    private TPMatchResult matchResult;
    private DispatcherType dispatcherType = DispatcherType.REQUEST;

    public TPHttpServletRequest(AutumnHttpRequest httpRequest, TPServletContext context, TPHttpExchange exchange) {
        this.httpRequest = httpRequest;
        this.context = context;
        this.exchange = exchange;
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        if (!this.httpRequest.getHeaders().containsKey("cookie")) {
            return null;
        }
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>();
        for (String cookieLine : (List)this.httpRequest.getHeaders().get("cookie")) {
            for (String cookieItem : cookieLine.split(";")) {
                String[] nameAndValue = cookieItem.split("=", 2);
                if (nameAndValue.length != 2) continue;
                cookieList.add(new Cookie(nameAndValue[0].trim(), nameAndValue[1].trim()));
            }
        }
        return cookieList.toArray(new Cookie[0]);
    }

    public long getDateHeader(String name) {
        if (!this.httpRequest.getHeaders().containsKey(name)) {
            return -1L;
        }
        String value = this.getHeader(name);
        try {
            Date date = new SimpleDateFormat("EEE dd MMM yyyy HH:mm:ss z").parse(value);
            return date.getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getHeader(String name) {
        String lower = name.toLowerCase();
        if (!this.httpRequest.getHeaders().containsKey(lower)) {
            return null;
        }
        return (String)((List)this.httpRequest.getHeaders().get(lower)).get(0);
    }

    public Enumeration<String> getHeaders(String name) {
        String lower = name.toLowerCase();
        if (!this.httpRequest.getHeaders().containsKey(lower)) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration((Collection)this.httpRequest.getHeaders().get(lower));
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.httpRequest.getHeaders().keySet());
    }

    public int getIntHeader(String name) {
        if (!this.httpRequest.getHeaders().containsKey(name)) {
            return -1;
        }
        return Integer.valueOf(this.getHeader(name));
    }

    public String getMethod() {
        return this.httpRequest.getMethod();
    }

    public String getPathInfo() {
        String[] pathAndQuery = this.httpRequest.getPath().split("\\?", 2);
        try {
            String pathInfo = pathAndQuery[0].substring(this.getServletPath().length());
            if (pathInfo.isEmpty()) {
                return null;
            }
            return pathInfo;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getPathTranslated() {
        return this.getPathInfo();
    }

    public String getContextPath() {
        return this.context.getContextPath();
    }

    public String getQueryString() {
        String[] pathAndQuery = this.httpRequest.getPath().split("\\?", 2);
        if (pathAndQuery.length > 1) {
            return pathAndQuery[1];
        }
        return null;
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getRequestedSessionId() {
        Cookie[] cookies = this.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("JSESSIONID")) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public String getRequestURI() {
        String[] pathAndQuery = this.httpRequest.getPath().split("\\?", 2);
        return pathAndQuery[0];
    }

    public StringBuffer getRequestURL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("http://");
        if (this.httpRequest.getHeaders().containsKey("host")) {
            buffer.append((String)((List)this.httpRequest.getHeaders().get("host")).get(0));
        } else {
            buffer.append(this.httpRequest.getLocalAddress());
        }
        buffer.append(this.getRequestURI());
        return buffer;
    }

    public String getServletPath() {
        if (this.matchResult == null) {
            return "";
        }
        return this.matchResult.getMatched();
    }

    public HttpSession getSession(boolean create) {
        String sessId = this.getRequestedSessionId();
        TPSessionContext sessionContext = this.context.getSessionContext();
        TPHttpSession session = null;
        if (sessId != null) {
            session = sessionContext.getSession(sessId);
        }
        if (session == null && create && !(session = sessionContext.createSession(sessId)).getId().equals(sessId)) {
            Cookie cookie = new Cookie("JSESSIONID", session.getId());
            cookie.setPath(this.context.getContextPath());
            cookie.setHttpOnly(true);
            this.exchange.getCookies().add(cookie);
        }
        return session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public String changeSessionId() {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return false;
    }

    public void login(String username, String password) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.getFormParts().values();
    }

    public Part getPart(String name) throws IOException, ServletException {
        return this.getFormParts().get(name);
    }

    private Map<String, TPFormPart> getFormParts() {
        if (this.formParts == null) {
            this.formParts = TPMultipartParser.parse(this.httpRequest);
        }
        return this.formParts;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        return null;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        if (this.encoding == null) {
            if (this.httpRequest.getHeaders().containsKey("content-type")) {
                String[] typeParts;
                for (String part : typeParts = ((String)((List)this.httpRequest.getHeaders().get("content-type")).get(0)).split(";")) {
                    String trimmed = part.trim();
                    if (!trimmed.startsWith("charset=")) continue;
                    this.encoding = trimmed.substring(8);
                }
            }
            if (this.encoding == null) {
                this.encoding = this.context.getRequestCharacterEncoding();
            }
        }
        return this.encoding;
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.encoding = env;
    }

    public int getContentLength() {
        if (this.httpRequest.getBody() == null) {
            return -1;
        }
        return this.httpRequest.getBody().length;
    }

    public long getContentLengthLong() {
        return this.getContentLength();
    }

    public String getContentType() {
        if (this.httpRequest.getHeaders().containsKey("content-type")) {
            String[] typeParts = ((String)((List)this.httpRequest.getHeaders().get("content-type")).get(0)).split(";", 2);
            return typeParts[0];
        }
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.httpRequest.getBody() == null) {
            return new TPInputStream(new byte[0]);
        }
        return new TPInputStream(this.httpRequest.getBody());
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null) {
            return null;
        }
        return values[0];
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public Map<String, String[]> getParameterMap() {
        if (this.params == null) {
            HashMap<String, List<String>> paramsMap = new HashMap<String, List<String>>();
            this.parseParamString(this.getQueryString(), paramsMap);
            if (this.getMethod().toLowerCase().equals("post")) {
                switch (this.getContentType()) {
                    case "application/x-www-form-urlencoded": {
                        this.parseParamString(new String(this.httpRequest.getBody()), paramsMap);
                        break;
                    }
                    case "multipart/form-data": {
                        try {
                            for (Part part : this.getParts()) {
                                if (!part.getContentType().equals("text/plain")) continue;
                                byte[] buf = new byte[(int)part.getSize()];
                                part.getInputStream().read(buf);
                                paramsMap.computeIfAbsent(part.getName(), x -> new ArrayList()).add(new String(buf));
                            }
                            break;
                        }
                        catch (IOException | ServletException throwable) {
                            // empty catch block
                        }
                    }
                }
            }
            this.params = new HashMap<String, String[]>();
            paramsMap.forEach((key, value) -> this.params.put((String)key, value.toArray(new String[0])));
        }
        return Collections.unmodifiableMap(this.params);
    }

    private void parseParamString(String paramStr, Map<String, List<String>> map) {
        String[] queries;
        if (paramStr == null) {
            return;
        }
        for (String query : queries = paramStr.split("&")) {
            String[] nameAndValue = query.split("=", 2);
            if (nameAndValue.length != 2) continue;
            List values = map.computeIfAbsent(nameAndValue[0], x -> new ArrayList());
            try {
                values.add(URLDecoder.decode(nameAndValue[1], this.getCharacterEncoding()));
            }
            catch (UnsupportedEncodingException e) {
                values.add(nameAndValue[1]);
            }
        }
    }

    public String getProtocol() {
        return this.httpRequest.getProtocol();
    }

    public String getScheme() {
        return "http";
    }

    public String getServerName() {
        if (this.httpRequest.getHeaders().containsKey("host")) {
            String host = (String)((List)this.httpRequest.getHeaders().get("host")).get(0);
            int pos = host.lastIndexOf(58);
            if (pos >= 0) {
                return host.substring(0, pos);
            }
            return host;
        }
        try {
            return ((InetSocketAddress)this.httpRequest.getLocalAddress()).getHostName();
        }
        catch (Exception e) {
            return "";
        }
    }

    public int getServerPort() {
        if (this.httpRequest.getHeaders().containsKey("host")) {
            String host = (String)((List)this.httpRequest.getHeaders().get("host")).get(0);
            int pos = host.lastIndexOf(58);
            if (pos >= 0) {
                try {
                    return Integer.parseInt(host.substring(pos + 1));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return 80;
        }
        return this.context.getEngine().getPort();
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.getCharacterEncoding()));
    }

    public String getRemoteAddr() {
        try {
            return ((InetSocketAddress)this.httpRequest.getRemoteAddress()).getAddress().getHostAddress();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getRemoteHost() {
        try {
            return ((InetSocketAddress)this.httpRequest.getRemoteAddress()).getHostString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setAttribute(String name, Object o) {
        if (this.attributes.containsKey(name)) {
            this.context.getListeners(ServletRequestAttributeListener.class).forEach(x -> x.attributeReplaced(new ServletRequestAttributeEvent((ServletContext)this.context, (ServletRequest)this, name, o)));
        } else {
            this.context.getListeners(ServletRequestAttributeListener.class).forEach(x -> x.attributeAdded(new ServletRequestAttributeEvent((ServletContext)this.context, (ServletRequest)this, name, o)));
        }
        this.attributes.put(name, o);
    }

    public void removeAttribute(String name) {
        this.context.getListeners(ServletRequestAttributeListener.class).forEach(x -> x.attributeRemoved(new ServletRequestAttributeEvent((ServletContext)this.context, (ServletRequest)this, name, this.attributes.get(name))));
        this.attributes.remove(name);
    }

    public Locale getLocale() {
        Enumeration<Locale> locales = this.getLocales();
        return locales.nextElement();
    }

    public Enumeration<Locale> getLocales() {
        String[] langs;
        if (!this.httpRequest.getHeaders().containsKey("accept-language")) {
            return Collections.enumeration(Collections.singleton(Locale.getDefault()));
        }
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String lang : langs = ((String)((List)this.httpRequest.getHeaders().get("accept-language")).get(0)).split(",")) {
            locales.add(Locale.forLanguageTag(lang.split(";", 2)[0].trim()));
        }
        return Collections.enumeration(locales);
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (!path.startsWith("/")) {
            path = this.getServletPath() + "/" + path;
        }
        return this.context.getRequestDispatcher(path);
    }

    public String getRealPath(String path) {
        return null;
    }

    public int getRemotePort() {
        try {
            return ((InetSocketAddress)this.httpRequest.getRemoteAddress()).getPort();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getLocalName() {
        try {
            return ((InetSocketAddress)this.httpRequest.getLocalAddress()).getHostString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getLocalAddr() {
        try {
            return ((InetSocketAddress)this.httpRequest.getLocalAddress()).getAddress().getHostAddress();
        }
        catch (Exception e) {
            return "";
        }
    }

    public int getLocalPort() {
        try {
            return ((InetSocketAddress)this.httpRequest.getLocalAddress()).getPort();
        }
        catch (Exception e) {
            return this.context.getEngine().getPort();
        }
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }

    public void setMatchResult(TPMatchResult matchResult) {
        this.matchResult = matchResult;
    }

    public void setDispatcherType(DispatcherType dispatcherType) {
        this.dispatcherType = dispatcherType;
    }
}

