/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.tompuss.filter;

import cn.imaq.tompuss.filter.TPFilterRegistration;
import cn.imaq.tompuss.util.TPUrlPattern;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;

public abstract class TPFilterMapping {
    private TPFilterRegistration registration;
    private Set<DispatcherType> dispatcherTypes;

    TPFilterMapping(TPFilterRegistration registration, Set<DispatcherType> dispatcherTypes) {
        this.registration = registration;
        this.dispatcherTypes = dispatcherTypes != null ? dispatcherTypes : Collections.singleton(DispatcherType.REQUEST);
    }

    public abstract boolean match(String var1, String var2);

    public TPFilterRegistration getRegistration() {
        return this.registration;
    }

    public Set<DispatcherType> getDispatcherTypes() {
        return this.dispatcherTypes;
    }

    static class ByUrlPattern
    extends TPFilterMapping {
        private List<TPUrlPattern> urlPatterns;

        ByUrlPattern(TPFilterRegistration registration, Set<DispatcherType> dispatcherTypes, String[] patterns) {
            super(registration, dispatcherTypes);
            this.urlPatterns = Arrays.stream(patterns).map(TPUrlPattern::new).collect(Collectors.toList());
        }

        @Override
        public boolean match(String path, String servletName) {
            if (path == null) {
                return false;
            }
            for (TPUrlPattern pattern : this.urlPatterns) {
                if (pattern.getType() == TPUrlPattern.Type.DEFAULT || pattern.match(path).getPatternLength() < 0) continue;
                return true;
            }
            return false;
        }
    }

    static class ByServlet
    extends TPFilterMapping {
        private Set<String> servletNames;

        ByServlet(TPFilterRegistration registration, Set<DispatcherType> dispatcherTypes, String[] servletNames) {
            super(registration, dispatcherTypes);
            this.servletNames = Arrays.stream(servletNames).collect(Collectors.toSet());
        }

        @Override
        public boolean match(String path, String servletName) {
            return servletName != null && this.servletNames.contains(servletName);
        }
    }
}

