/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.tompuss.dispatcher;

import cn.imaq.tompuss.dispatcher.TPRequestDispatcher;
import cn.imaq.tompuss.filter.TPFilterChain;
import cn.imaq.tompuss.servlet.TPHttpServletRequest;
import cn.imaq.tompuss.servlet.TPServletContext;
import cn.imaq.tompuss.servlet.TPServletRegistration;
import cn.imaq.tompuss.util.TPMatchResult;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPPathDispatcher
extends TPRequestDispatcher {
    private static final Logger log = LoggerFactory.getLogger(TPPathDispatcher.class);
    private String path;

    public TPPathDispatcher(TPServletContext context, String path) {
        super(context);
        this.path = path;
    }

    @Override
    protected void dispatch(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        TPMatchResult<TPServletRegistration> servletMatch = this.context.matchServletByPath(this.path);
        ((TPHttpServletRequest)request).setMatchResult(servletMatch);
        Servlet servlet = null;
        if (servletMatch != null) {
            servlet = servletMatch.getObject().getServletInstance();
        }
        if (servlet == null || !(servlet instanceof HttpServlet)) {
            servlet = this.context.getDefaultServletRegistration().getServletInstance();
        }
        if (servlet == null || !(servlet instanceof HttpServlet)) {
            ((HttpServletResponse)response).sendError(404);
            return;
        }
        TPFilterChain filterChain = this.context.matchFilters(this.path, servlet, request.getDispatcherType());
        filterChain.doFilter(request, response);
    }
}

