/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.tompuss.util;

import cn.imaq.tompuss.servlet.TPServletContext;
import java.io.File;
import java.util.EnumSet;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletRegistration;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPXmlUtil {
    private static final Logger log = LoggerFactory.getLogger(TPXmlUtil.class);

    public static void parseWebXml(TPServletContext context, File xmlFile) {
        log.info("Loading XML config file " + xmlFile);
        try {
            Element root = new SAXReader().read(xmlFile).getRootElement();
            for (Element element : root.elements()) {
                switch (element.getName()) {
                    case "context-param": {
                        context.setInitParameter(element.elementTextTrim("param-name"), element.elementText("param-value"));
                        break;
                    }
                    case "servlet": {
                        Element asyncSupported;
                        ServletRegistration.Dynamic sRegDyn = context.addServlet(element.elementTextTrim("servlet-name"), element.elementTextTrim("servlet-class"));
                        for (Element initParam : element.elements("init-param")) {
                            sRegDyn.setInitParameter(initParam.elementTextTrim("param-name"), initParam.elementText("param-value"));
                        }
                        Element loadOnStartup = element.element("load-on-startup");
                        if (loadOnStartup != null) {
                            sRegDyn.setLoadOnStartup(Integer.parseInt(loadOnStartup.getTextTrim()));
                        }
                        if ((asyncSupported = element.element("async-supported")) == null) break;
                        sRegDyn.setAsyncSupported(asyncSupported.getTextTrim().equals("true"));
                        break;
                    }
                    case "servlet-mapping": {
                        ServletRegistration sReg = context.getServletRegistration(element.elementTextTrim("servlet-name"));
                        if (sReg == null) break;
                        sReg.addMapping((String[])element.elements("url-pattern").stream().map(Element::getTextTrim).toArray(String[]::new));
                        break;
                    }
                    case "filter": {
                        FilterRegistration.Dynamic fRegDyn = context.addFilter(element.elementTextTrim("filter-name"), element.elementTextTrim("filter-class"));
                        for (Element initParam : element.elements("init-param")) {
                            fRegDyn.setInitParameter(initParam.elementTextTrim("param-name"), initParam.elementText("param-value"));
                        }
                        Element asyncSupported = element.element("async-supported");
                        if (asyncSupported == null) break;
                        fRegDyn.setAsyncSupported(asyncSupported.getTextTrim().equals("true"));
                        break;
                    }
                    case "filter-mapping": {
                        FilterRegistration fReg = context.getFilterRegistration(element.elementTextTrim("filter-name"));
                        if (fReg == null) break;
                        EnumSet<Object> dispatcherTypes = EnumSet.copyOf(element.elements("dispatcher").stream().map(e -> DispatcherType.valueOf((String)e.getTextTrim())).collect(Collectors.toSet()));
                        if (dispatcherTypes.isEmpty()) {
                            dispatcherTypes = EnumSet.of(DispatcherType.REQUEST);
                        }
                        fReg.addMappingForServletNames(dispatcherTypes, true, (String[])element.elements("servlet-name").stream().map(Element::getTextTrim).toArray(String[]::new));
                        fReg.addMappingForUrlPatterns(dispatcherTypes, true, (String[])element.elements("url-pattern").stream().map(Element::getTextTrim).toArray(String[]::new));
                        break;
                    }
                    case "listener": {
                        context.addListener(element.elementTextTrim("listener-class"));
                    }
                }
            }
        }
        catch (Exception e2) {
            log.warn("Load XML config failed: " + e2);
        }
    }
}

