/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.tompuss.io;

import java.io.IOException;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;

public class TPInputStream
extends ServletInputStream {
    private byte[] buf;
    private int pos;
    private int mark = 0;
    private int count;

    public TPInputStream(byte[] buf) {
        this.buf = buf;
        this.pos = 0;
        this.count = buf.length;
    }

    public synchronized int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    public synchronized int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        int avail = this.count - this.pos;
        if (len > avail) {
            len = avail;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    public synchronized long skip(long n) {
        long k = this.count - this.pos;
        if (n < k) {
            k = n < 0L ? 0L : n;
        }
        this.pos = (int)((long)this.pos + k);
        return k;
    }

    public synchronized int available() {
        return this.count - this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readAheadLimit) {
        this.mark = this.pos;
    }

    public synchronized void reset() {
        this.pos = this.mark;
    }

    public void close() throws IOException {
    }

    public boolean isFinished() {
        return this.count - this.pos <= 0;
    }

    public boolean isReady() {
        return true;
    }

    public void setReadListener(ReadListener readListener) {
        try {
            readListener.onDataAvailable();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

