/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.tompuss.core;

import cn.imaq.tompuss.filter.TPFilterChain;
import cn.imaq.tompuss.servlet.TPHttpServletRequest;
import cn.imaq.tompuss.servlet.TPHttpServletResponse;
import cn.imaq.tompuss.servlet.TPServletContext;
import cn.imaq.tompuss.servlet.TPServletRegistration;
import cn.imaq.tompuss.util.TPMatchResult;
import cn.imaq.tompuss.util.TPNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPRequestDispatcher
implements RequestDispatcher {
    private static final Logger log = LoggerFactory.getLogger(TPRequestDispatcher.class);
    private TPServletContext context;
    private String resPath;

    public TPRequestDispatcher(TPServletContext context, String resPath) {
        this.context = context;
        this.resPath = resPath;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (request instanceof TPHttpServletRequest) {
            TPHttpServletRequest httpServletRequest = (TPHttpServletRequest)request;
            httpServletRequest.setDispatcherType(DispatcherType.FORWARD);
            httpServletRequest.setAttribute("javax.servlet.forward.request_uri", httpServletRequest.getRequestURI());
            httpServletRequest.setAttribute("javax.servlet.forward.context_path", httpServletRequest.getContextPath());
            httpServletRequest.setAttribute("javax.servlet.forward.path_info", httpServletRequest.getPathInfo());
            httpServletRequest.setAttribute("javax.servlet.forward.servlet_path", httpServletRequest.getServletPath());
            httpServletRequest.setAttribute("javax.servlet.forward.query_string", httpServletRequest.getQueryString());
        }
        response.resetBuffer();
        this.dispatch(request, response);
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (request instanceof TPHttpServletRequest) {
            ((TPHttpServletRequest)request).setDispatcherType(DispatcherType.INCLUDE);
        }
        this.dispatch(request, response);
    }

    public void request(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.dispatch(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        TPMatchResult<TPServletRegistration> servletMatch = this.context.matchServletByPath(this.resPath);
        ((TPHttpServletRequest)request).setMatchResult(servletMatch);
        if (servletMatch == null) {
            this.dispatchResource(response);
            return;
        }
        Servlet servlet = servletMatch.getObject().getServletInstance();
        if (!(servlet instanceof HttpServlet)) {
            this.dispatchResource(response);
            return;
        }
        this.context.getListeners(ServletRequestListener.class).forEach(x -> x.requestInitialized(new ServletRequestEvent((ServletContext)this.context, request)));
        TPFilterChain filterChain = this.context.matchFilters(this.resPath, servlet, request.getDispatcherType());
        try {
            filterChain.doFilter(request, response);
        }
        finally {
            this.context.getListeners(ServletRequestListener.class).forEach(x -> x.requestDestroyed(new ServletRequestEvent((ServletContext)this.context, request)));
        }
    }

    public void dispatchResource(ServletResponse response) throws TPNotFoundException, IOException {
        InputStream is = this.context.getResourceAsStream(this.resPath);
        if (is == null) {
            throw new TPNotFoundException();
        }
        String mimeType = this.context.getMimeType(this.resPath);
        response.reset();
        response.setContentType(mimeType);
        byte[] buf = new byte[is.available()];
        is.read(buf);
        ((TPHttpServletResponse)response).setBody(buf);
    }
}

