/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.tompuss.session;

import cn.imaq.tompuss.servlet.TPServletContext;
import cn.imaq.tompuss.session.TPHttpSession;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class TPSessionContext {
    private TPServletContext context;
    private Map<String, TPHttpSession> sessions = new ConcurrentHashMap<String, TPHttpSession>();

    public TPSessionContext(TPServletContext context) {
        this.context = context;
    }

    public TPHttpSession getSession(String sessId) {
        TPHttpSession session = this.sessions.get(sessId);
        if (session == null) {
            return null;
        }
        if (!session.isValid()) {
            this.context.getListeners(HttpSessionListener.class).forEach(x -> x.sessionDestroyed(new HttpSessionEvent((HttpSession)session)));
            return null;
        }
        return session;
    }

    public TPHttpSession createSession(String oldSessId) {
        String sessId = oldSessId;
        if (sessId == null) {
            while (this.sessions.containsKey(sessId = "tompuss_" + UUID.randomUUID())) {
            }
        }
        TPHttpSession session = new TPHttpSession(this.context, sessId);
        this.sessions.put(sessId, session);
        this.context.getListeners(HttpSessionListener.class).forEach(x -> x.sessionCreated(new HttpSessionEvent((HttpSession)session)));
        return session;
    }
}

