/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.tompuss.servlet;

import cn.imaq.tompuss.core.TPRegistration;
import cn.imaq.tompuss.servlet.TPServletContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPServletRegistration
extends TPRegistration<Servlet>
implements ServletRegistration.Dynamic {
    private static final Logger log = LoggerFactory.getLogger(TPServletRegistration.class);
    private int loadOnStartup = -1;
    private ServletSecurityElement securityElement;
    private MultipartConfigElement multipartConfig;
    private String runAsRole;
    private Queue<String> mappings = new ConcurrentLinkedQueue<String>();

    public TPServletRegistration(TPServletContext context, String name, Servlet instance) {
        super(context, name, instance);
    }

    public void loadAnnotation(WebServlet ws) {
        this.addMapping(ws.value());
        this.addMapping(ws.urlPatterns());
        this.setLoadOnStartup(ws.loadOnStartup());
        this.setAsyncSupported(ws.asyncSupported());
        for (WebInitParam initParam : ws.initParams()) {
            this.setInitParameter(initParam.name(), initParam.value());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servlet getServletInstance() {
        if (((Servlet)this.instance).getServletConfig() == null) {
            TPServletRegistration tPServletRegistration = this;
            synchronized (tPServletRegistration) {
                if (((Servlet)this.instance).getServletConfig() == null) {
                    log.info("Initiating Servlet " + this.name + "[" + ((Servlet)this.instance).getClass().getName() + "]");
                    ServletConfig config = new ServletConfig(){

                        public String getServletName() {
                            return TPServletRegistration.this.name;
                        }

                        public ServletContext getServletContext() {
                            return TPServletRegistration.this.context;
                        }

                        public String getInitParameter(String name) {
                            return TPServletRegistration.this.getInitParameter(name);
                        }

                        public Enumeration<String> getInitParameterNames() {
                            return Collections.enumeration(TPServletRegistration.this.getInitParameters().keySet());
                        }
                    };
                    try {
                        ((Servlet)this.instance).init(config);
                    }
                    catch (ServletException e) {
                        log.error("Error initiating Servlet " + this.name + "[" + ((Servlet)this.instance).getClass().getName() + "]", (Throwable)e);
                    }
                }
            }
        }
        return (Servlet)this.instance;
    }

    public void setLoadOnStartup(int loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    public Set<String> setServletSecurity(ServletSecurityElement constraint) {
        if (constraint == null) {
            throw new IllegalArgumentException();
        }
        this.securityElement = constraint;
        return Collections.emptySet();
    }

    public void setMultipartConfig(MultipartConfigElement multipartConfig) {
        if (multipartConfig == null) {
            throw new IllegalArgumentException();
        }
        this.multipartConfig = multipartConfig;
    }

    public void setRunAsRole(String roleName) {
        if (roleName == null) {
            throw new IllegalArgumentException();
        }
        this.runAsRole = roleName;
    }

    public Set<String> addMapping(String ... urlPatterns) {
        HashSet<String> conflicts = new HashSet<String>();
        for (String pattern : urlPatterns) {
            if (this.context.addServletMapping(pattern, this)) {
                this.mappings.add(pattern);
                continue;
            }
            conflicts.add(pattern);
        }
        return conflicts;
    }

    public Collection<String> getMappings() {
        return Collections.unmodifiableCollection(this.mappings);
    }

    public String getRunAsRole() {
        return this.runAsRole;
    }

    public int getLoadOnStartup() {
        return this.loadOnStartup;
    }
}

