/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.tompuss.servlet;

import cn.imaq.tompuss.core.TPEngine;
import cn.imaq.tompuss.core.TPRequestDispatcher;
import cn.imaq.tompuss.filter.TPFilterChain;
import cn.imaq.tompuss.filter.TPFilterMapping;
import cn.imaq.tompuss.filter.TPFilterRegistration;
import cn.imaq.tompuss.servlet.TPServletRegistration;
import cn.imaq.tompuss.session.TPSessionContext;
import cn.imaq.tompuss.util.TPMatchResult;
import cn.imaq.tompuss.util.TPPathUtil;
import cn.imaq.tompuss.util.TPUrlPattern;
import cn.imaq.tompuss.util.TPXmlUtil;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpFilter;
import javax.servlet.http.HttpServlet;
import org.apache.jasper.servlet.JspServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPServletContext
implements ServletContext {
    private static final Logger log = LoggerFactory.getLogger(TPServletContext.class);
    private TPEngine engine;
    private String appName;
    private String contextPath;
    private File resourceRoot;
    private volatile boolean started = false;
    private TPSessionContext sessionContext = new TPSessionContext(this);
    private int sessionTimeout;
    private String requestEncoding = "utf-8";
    private String responseEncoding = "utf-8";
    private Map<String, String> initParams = new ConcurrentHashMap<String, String>();
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private Map<String, TPServletRegistration> servletRegistrations = new ConcurrentHashMap<String, TPServletRegistration>();
    private Map<TPUrlPattern, TPServletRegistration> servletMappings = new ConcurrentHashMap<TPUrlPattern, TPServletRegistration>();
    private Map<String, TPFilterRegistration> filterRegistrations = new ConcurrentHashMap<String, TPFilterRegistration>();
    private Deque<TPFilterMapping> filterMappings = new ConcurrentLinkedDeque<TPFilterMapping>();
    private Map<Class<? extends EventListener>, Queue<EventListener>> listeners = new ConcurrentHashMap<Class<? extends EventListener>, Queue<EventListener>>();

    public TPServletContext(TPEngine engine, String appName, String contextPath, File resourceRoot) {
        this.engine = engine;
        this.appName = appName;
        this.contextPath = TPPathUtil.transform(contextPath);
        this.resourceRoot = resourceRoot;
    }

    public synchronized void loadConfigFile(String fileName) {
        TPXmlUtil.parseWebXml(this, new File(this.resourceRoot, fileName));
    }

    public synchronized void scanAnnotations() {
        log.info("Scanning annotations in classpath ...");
        new FastClasspathScanner(new String[0]).matchClassesWithAnnotation(WebServlet.class, cls -> {
            if (HttpServlet.class.isAssignableFrom(cls)) {
                WebServlet ws = cls.getAnnotation(WebServlet.class);
                TPServletRegistration registration = (TPServletRegistration)this.addServlet(ws.name().isEmpty() ? cls.getName() : ws.name(), cls);
                registration.loadAnnotation(ws);
            }
        }).matchClassesWithAnnotation(WebFilter.class, cls -> {
            if (HttpFilter.class.isAssignableFrom(cls)) {
                WebFilter wf = cls.getAnnotation(WebFilter.class);
                TPFilterRegistration registration = (TPFilterRegistration)this.addFilter(wf.filterName().isEmpty() ? cls.getName() : wf.filterName(), cls);
                registration.loadAnnotation(wf);
            }
        }).matchClassesWithAnnotation(WebListener.class, cls -> {
            if (EventListener.class.isAssignableFrom(cls)) {
                this.addListener(cls);
            }
        }).scan();
    }

    public synchronized void enableJsp() {
        log.info("Enabling JSP support ...");
        System.setProperty("org.apache.jasper.compiler.disablejsr199", "true");
        this.addServlet("JspServlet", JspServlet.class).addMapping(new String[]{"*.jsp"});
    }

    public synchronized void startup() {
        log.info("Starting up context ...");
        if (!this.started) {
            TreeMap<Integer, List> servletStartupMap = new TreeMap<Integer, List>();
            for (TPServletRegistration servletRegistration : this.servletRegistrations.values()) {
                if (servletRegistration.getLoadOnStartup() < 0) continue;
                servletStartupMap.computeIfAbsent(servletRegistration.getLoadOnStartup(), x -> new LinkedList()).add(servletRegistration);
            }
            for (List servletRegistrations : servletStartupMap.values()) {
                for (TPServletRegistration servletRegistration : servletRegistrations) {
                    servletRegistration.getServletInstance();
                }
            }
            this.getListeners(ServletContextListener.class).forEach(x -> x.contextInitialized(new ServletContextEvent((ServletContext)this)));
            this.started = true;
        }
    }

    public TPMatchResult<TPServletRegistration> matchServletByPath(String path) {
        TPServletRegistration result = null;
        TPUrlPattern.Match bestMatch = TPUrlPattern.Match.NO_MATCH;
        for (Map.Entry<TPUrlPattern, TPServletRegistration> mapEntry : this.servletMappings.entrySet()) {
            TPUrlPattern.Match match = mapEntry.getKey().match(path);
            if (match.compareTo(bestMatch) <= 0) continue;
            bestMatch = match;
            result = mapEntry.getValue();
        }
        if (result != null) {
            return new TPMatchResult<Object>(bestMatch.getMatched(), result);
        }
        return null;
    }

    public TPFilterChain matchFilters(String path, Servlet servlet, DispatcherType dispatcherType) {
        LinkedHashSet<TPFilterRegistration> filters = new LinkedHashSet<TPFilterRegistration>();
        for (TPFilterMapping mapping : this.filterMappings) {
            if (!mapping.getDispatcherTypes().contains(dispatcherType) || !mapping.match(path, servlet.getServletConfig().getServletName())) continue;
            filters.add(mapping.getRegistration());
        }
        return new TPFilterChain(filters, servlet);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ServletContext getContext(String uripath) {
        TPMatchResult<TPServletContext> result = this.engine.matchContextByPath(uripath);
        if (result == null) {
            return null;
        }
        return result.getObject();
    }

    public int getMajorVersion() {
        return 4;
    }

    public int getMinorVersion() {
        return 0;
    }

    public int getEffectiveMajorVersion() {
        return this.getMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.getMinorVersion();
    }

    public String getMimeType(String file) {
        try {
            return Files.probeContentType(Paths.get(new File(this.resourceRoot, file).toURI()));
        }
        catch (IOException e) {
            return "application/octet-stream";
        }
    }

    public Set<String> getResourcePaths(String path) {
        return null;
    }

    public URL getResource(String path) throws MalformedURLException {
        if (this.resourceRoot == null) {
            return null;
        }
        File resFile = new File(this.resourceRoot, path);
        if (resFile.exists()) {
            return resFile.toURI().toURL();
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        if (this.resourceRoot == null) {
            return null;
        }
        try {
            return new FileInputStream(new File(this.resourceRoot, path));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new TPRequestDispatcher(this, path);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return null;
    }

    public Servlet getServlet(String name) throws ServletException {
        return null;
    }

    public Enumeration<Servlet> getServlets() {
        return Collections.emptyEnumeration();
    }

    public Enumeration<String> getServletNames() {
        return Collections.emptyEnumeration();
    }

    public void log(String msg) {
        log.info(msg);
    }

    public void log(Exception exception, String msg) {
        this.log(msg, exception);
    }

    public void log(String message, Throwable throwable) {
        log.error(message, throwable);
    }

    public String getRealPath(String path) {
        return null;
    }

    public String getServerInfo() {
        return "TomPuss/1.0";
    }

    public String getInitParameter(String name) {
        return this.initParams.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParams.keySet());
    }

    public boolean setInitParameter(String name, String value) {
        if (this.initParams.containsKey(name)) {
            return false;
        }
        this.initParams.put(name, value);
        return true;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public void setAttribute(String name, Object object) {
        if (this.attributes.containsKey(name)) {
            this.getListeners(ServletContextAttributeListener.class).forEach(x -> x.attributeReplaced(new ServletContextAttributeEvent((ServletContext)this, name, object)));
        } else {
            this.getListeners(ServletContextAttributeListener.class).forEach(x -> x.attributeAdded(new ServletContextAttributeEvent((ServletContext)this, name, object)));
        }
        this.attributes.put(name, object);
    }

    public void removeAttribute(String name) {
        this.getListeners(ServletContextAttributeListener.class).forEach(x -> x.attributeRemoved(new ServletContextAttributeEvent((ServletContext)this, name, this.attributes.get(name))));
        this.attributes.remove(name);
    }

    public String getServletContextName() {
        return this.appName;
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        try {
            Class<?> servletClass = Class.forName(className);
            return this.addServlet(servletName, servletClass);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        if (servletName == null || servletName.isEmpty()) {
            throw new IllegalArgumentException();
        }
        log.info("Adding Servlet " + servletName + "[" + servlet.getClass().getName() + "]");
        TPServletRegistration registration = new TPServletRegistration(this, servletName, servlet);
        this.servletRegistrations.put(servletName, registration);
        return registration;
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        try {
            return this.addServlet(servletName, this.createServlet(servletClass));
        }
        catch (ServletException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean addServletMapping(String pattern, TPServletRegistration registration) {
        return this.servletMappings.putIfAbsent(new TPUrlPattern(pattern), registration) == null;
    }

    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        return null;
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        try {
            return (T)((Servlet)clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return (ServletRegistration)this.servletRegistrations.get(servletName);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return Collections.unmodifiableMap(this.servletRegistrations);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        try {
            Class<?> filterClass = Class.forName(className);
            return this.addFilter(filterName, filterClass);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        if (filterName == null || filterName.isEmpty()) {
            throw new IllegalArgumentException();
        }
        log.info("Adding Filter " + filterName + "[" + filter.getClass().getName() + "]");
        TPFilterRegistration registration = new TPFilterRegistration(this, filterName, filter);
        this.filterRegistrations.put(filterName, registration);
        return registration;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        try {
            return this.addFilter(filterName, this.createFilter(filterClass));
        }
        catch (ServletException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void addFilterMapping(TPFilterMapping mapping, boolean isMatchAfter) {
        if (isMatchAfter) {
            this.filterMappings.addLast(mapping);
        } else {
            this.filterMappings.addFirst(mapping);
        }
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        try {
            return (T)((Filter)clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return (FilterRegistration)this.filterRegistrations.get(filterName);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return Collections.unmodifiableMap(this.filterRegistrations);
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return null;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return Collections.singleton(SessionTrackingMode.COOKIE);
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return null;
    }

    public void addListener(String className) {
        try {
            Class<?> listenerClass = Class.forName(className);
            this.addListener(listenerClass);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T extends EventListener> void addListener(T t) {
        log.info("Adding Listener " + t.getClass().getName());
        for (Class<?> intf : t.getClass().getInterfaces()) {
            if (!EventListener.class.isAssignableFrom(intf)) continue;
            this.listeners.computeIfAbsent(intf, x -> new ConcurrentLinkedQueue()).add(t);
        }
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        try {
            this.addListener(this.createListener(listenerClass));
        }
        catch (ServletException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        try {
            return (T)((EventListener)clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public <T extends EventListener> Collection<T> getListeners(Class<T> listenerClass) {
        if (!this.listeners.containsKey(listenerClass)) {
            return Collections.emptyList();
        }
        return this.listeners.get(listenerClass);
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public void declareRoles(String ... roleNames) {
    }

    public String getVirtualServerName() {
        return "";
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public String getRequestCharacterEncoding() {
        return this.requestEncoding;
    }

    public void setRequestCharacterEncoding(String encoding) {
        this.requestEncoding = encoding;
    }

    public String getResponseCharacterEncoding() {
        return this.responseEncoding;
    }

    public void setResponseCharacterEncoding(String encoding) {
        this.responseEncoding = encoding;
    }

    public TPEngine getEngine() {
        return this.engine;
    }

    public TPSessionContext getSessionContext() {
        return this.sessionContext;
    }
}

