/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.tompuss.core;

import cn.imaq.autumn.http.protocol.AutumnHttpRequest;
import cn.imaq.autumn.http.protocol.AutumnHttpResponse;
import cn.imaq.autumn.http.server.protocol.AutumnHttpHandler;
import cn.imaq.tompuss.core.TPEngine;
import cn.imaq.tompuss.core.TPRequestDispatcher;
import cn.imaq.tompuss.servlet.TPHttpExchange;
import cn.imaq.tompuss.servlet.TPHttpServletRequest;
import cn.imaq.tompuss.servlet.TPHttpServletResponse;
import cn.imaq.tompuss.servlet.TPServletContext;
import cn.imaq.tompuss.util.TPMatchResult;
import cn.imaq.tompuss.util.TPNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPDispatcher
implements AutumnHttpHandler {
    private static final Logger log = LoggerFactory.getLogger(TPDispatcher.class);
    private static final byte[] INFO_404 = "<html><head><title>Not Found</title></head><body><center><h1>404 Not Found</h1></center><hr><center>TomPuss</center></body></html>".getBytes();
    private TPEngine engine;

    TPDispatcher(TPEngine engine) {
        this.engine = engine;
    }

    public AutumnHttpResponse handle(AutumnHttpRequest request) {
        String path = request.getPath().split("\\?", 2)[0];
        TPMatchResult<TPServletContext> contextMatch = this.engine.matchContextByPath(path);
        if (contextMatch == null) {
            return TPDispatcher.notFound();
        }
        TPServletContext context = contextMatch.getObject();
        String remainPath = path.substring(contextMatch.getMatched().length() - 1);
        TPHttpExchange exchange = new TPHttpExchange();
        TPHttpServletRequest req = new TPHttpServletRequest(request, context, exchange);
        TPHttpServletResponse resp = new TPHttpServletResponse(context, exchange);
        try {
            ((TPRequestDispatcher)context.getRequestDispatcher(remainPath)).request((ServletRequest)req, (ServletResponse)resp);
        }
        catch (TPNotFoundException e) {
            return TPDispatcher.notFound();
        }
        catch (Throwable e) {
            log.warn("Exception in dispatcher", e);
            return TPDispatcher.error(e);
        }
        if (resp.getStatus() == 404) {
            TPHttpServletResponse resResp = new TPHttpServletResponse(context, exchange);
            try {
                ((TPRequestDispatcher)context.getRequestDispatcher(remainPath)).dispatchResource((ServletResponse)resResp);
                resp = resResp;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return resp.toAutumnHttpResponse();
    }

    private static AutumnHttpResponse notFound() {
        return AutumnHttpResponse.builder().status(404).contentType("text/html").body(INFO_404).build();
    }

    private static AutumnHttpResponse error(Throwable e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter((Writer)writer, true));
        return AutumnHttpResponse.builder().status(500).contentType("text/html").body(("<html><head><title>Server Error</title></head><body><h1>Server Error</h1><pre>" + ((Object)writer).toString() + "</pre><hr>TomPuss</body></html>").getBytes()).build();
    }
}

