/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rpc.server.net;

import cn.imaq.autumn.rpc.server.exception.AutumnInvokeException;
import cn.imaq.autumn.rpc.server.invoker.AutumnInvoker;
import cn.imaq.autumn.rpc.server.invoker.AutumnInvokerFactory;
import cn.imaq.autumn.rpc.server.net.AutumnRPCRequest;
import cn.imaq.autumn.rpc.server.net.AutumnRPCResponse;
import cn.imaq.autumn.rpc.server.util.InstanceMap;
import cn.imaq.autumn.rpc.server.util.LogUtil;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.rapidoid.buffer.Buf;
import org.rapidoid.http.AbstractHttpServer;
import org.rapidoid.http.HttpResponseCodes;
import org.rapidoid.http.HttpStatus;
import org.rapidoid.http.MediaType;
import org.rapidoid.net.Server;
import org.rapidoid.net.abstracts.Channel;
import org.rapidoid.net.impl.RapidoidHelper;

public class AutumnRPCHttpServer
extends AbstractHttpServer {
    private final byte[] ROOT_PATH = new byte[]{47};
    private final byte[] METHOD_POST = "POST".getBytes();
    private final byte[] INFO_400 = "<html><head><title>400 Bad Request</title></head><body><center><h1>400 Bad Request</h1></center><hr><center>AutumnRPC</center></body></html>".getBytes();
    private final byte[] INFO_500 = "<html><head><title>500 Internal Server Error</title></head><body><center><h1>500 Internal Server Error</h1></center><hr><center>AutumnRPC</center></body></html>".getBytes();
    private final InstanceMap instanceMap = new InstanceMap();
    private AutumnInvoker invoker;

    public AutumnRPCHttpServer() {
        super("AutumnRPC", "Not Found", "Internal Server Error", true);
    }

    public InstanceMap getInstanceMap() {
        return this.instanceMap;
    }

    public Server start(String host, int port) {
        this.invoker = AutumnInvokerFactory.getInvoker();
        LogUtil.W("Using invoker: " + this.invoker.getClass().getSimpleName());
        return this.listen(host, port);
    }

    protected HttpStatus handle(Channel ctx, Buf buf, RapidoidHelper req) {
        String serviceName;
        Object instance;
        String[] paths;
        String verb = req.verb.str(buf);
        String path = req.path.str(buf);
        LogUtil.D("Received HTTP request: " + verb + " " + path);
        if (!req.isGet.value || this.matches(buf, req.path, this.ROOT_PATH)) {
            // empty if block
        }
        if ((paths = path.split("/")).length >= 2 && (instance = this.instanceMap.getInstance(serviceName = paths[1])) != null) {
            byte[] body = req.body.bytes(buf);
            ObjectMapper mapper = new ObjectMapper();
            try {
                AutumnRPCRequest request = (AutumnRPCRequest)mapper.readValue(body, AutumnRPCRequest.class);
                if (request.getParamTypes().length == request.getParams().length) {
                    try {
                        Object[] realParams = new Object[request.getParams().length];
                        for (int i = 0; i < request.getParams().length; ++i) {
                            realParams[i] = mapper.treeToValue((TreeNode)request.getParams()[i], request.getParamTypes()[i]);
                        }
                        Object result = this.invoker.invoke(instance, request.getMethodName(), request.getParamTypes(), realParams);
                        return this.ok(ctx, true, mapper.writeValueAsBytes((Object)new AutumnRPCResponse(0, result)), MediaType.JSON);
                    }
                    catch (AutumnInvokeException e) {
                        LogUtil.E("Error invoking " + serviceName + "#" + request.getMethodName() + ": " + e.getCause());
                        return this.error(ctx);
                    }
                    catch (InvocationTargetException e) {
                        LogUtil.E(serviceName + "#" + request.getMethodName() + " threw an exception: " + e.getCause());
                        return this.ok(ctx, true, mapper.writeValueAsBytes((Object)new AutumnRPCResponse(-1, e.getCause())), MediaType.JSON);
                    }
                }
            }
            catch (IOException e) {
                LogUtil.E("Error parsing request: " + e.getClass().getSimpleName());
            }
        }
        return this.badRequest(ctx);
    }

    private HttpStatus badRequest(Channel ctx) {
        ctx.write(HttpResponseCodes.get((int)400));
        this.writeCommonHeaders(ctx, false);
        this.writeBody(ctx, this.INFO_400, MediaType.HTML_UTF_8);
        return HttpStatus.DONE;
    }

    private HttpStatus error(Channel ctx) {
        ctx.write(HttpResponseCodes.get((int)500));
        this.writeCommonHeaders(ctx, false);
        this.writeBody(ctx, this.INFO_500, MediaType.HTML_UTF_8);
        return HttpStatus.DONE;
    }
}

