/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rpc.server;

import cn.imaq.autumn.rpc.server.net.AutumnRPCHttpServer;
import cn.imaq.autumn.rpc.server.scanner.AutumnRPCScanner;
import cn.imaq.autumn.rpc.server.util.AutumnRPCBanner;
import cn.imaq.autumn.rpc.server.util.ConfigUtil;
import cn.imaq.autumn.rpc.server.util.LogUtil;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import org.rapidoid.net.Server;

public class AutumnRPCServer {
    private static final AutumnRPCHttpServer httpServer = new AutumnRPCHttpServer();
    private static Server listeningServer;

    public static void start() {
        AutumnRPCServer.start(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(String configFile) {
        AutumnRPCHttpServer autumnRPCHttpServer = httpServer;
        synchronized (autumnRPCHttpServer) {
            AutumnRPCServer.stop();
            AutumnRPCBanner.printBanner();
            ConfigUtil.loadConfig(configFile);
            LogUtil.W("Scanning services to expose ...");
            httpServer.getInstanceMap().clear();
            FastClasspathScanner classpathScanner = new FastClasspathScanner(new String[0]);
            new FastClasspathScanner(new String[0]).matchClassesImplementing(AutumnRPCScanner.class, scanner -> {
                LogUtil.W("Scanning with scanner " + scanner.getSimpleName());
                try {
                    ((AutumnRPCScanner)scanner.newInstance()).process(classpathScanner, httpServer.getInstanceMap());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    LogUtil.E("Error instantiating scanner " + scanner.getSimpleName());
                }
            }).scan();
            classpathScanner.scan();
            String host = ConfigUtil.get("http.host");
            Integer port = Integer.valueOf(ConfigUtil.get("http.port"));
            LogUtil.W("Starting HTTP server on " + host + ":" + port);
            listeningServer = httpServer.start(host, port);
            LogUtil.W("Bootstrap success");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        AutumnRPCHttpServer autumnRPCHttpServer = httpServer;
        synchronized (autumnRPCHttpServer) {
            if (listeningServer != null && listeningServer.isActive()) {
                listeningServer.shutdown();
            }
        }
    }
}

