/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.aop;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class HookModel {
    private List<JoinPoint> includes;
    private List<JoinPoint> excludes;
    private Method hook;

    public HookModel(String[] includes, String[] excludes, Method hook) {
        this.includes = Arrays.stream(includes).map(x$0 -> new JoinPoint((String)x$0)).collect(Collectors.toList());
        this.excludes = Arrays.stream(excludes).map(x$0 -> new JoinPoint((String)x$0)).collect(Collectors.toList());
        this.hook = hook;
    }

    public boolean matches(Class<?> clazz) {
        String className = clazz.getName();
        for (JoinPoint includePoint : this.includes) {
            if (!includePoint.matchesClass(className)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(Method method) {
        String className = method.getDeclaringClass().getName();
        String methodName = method.getName();
        for (JoinPoint excludePoint : this.excludes) {
            if (!excludePoint.matchesMethod(className, methodName)) continue;
            return false;
        }
        for (JoinPoint includePoint : this.includes) {
            if (!includePoint.matchesMethod(className, methodName)) continue;
            return true;
        }
        return false;
    }

    public List<JoinPoint> getIncludes() {
        return this.includes;
    }

    public List<JoinPoint> getExcludes() {
        return this.excludes;
    }

    public Method getHook() {
        return this.hook;
    }

    public void setIncludes(List<JoinPoint> includes) {
        this.includes = includes;
    }

    public void setExcludes(List<JoinPoint> excludes) {
        this.excludes = excludes;
    }

    public void setHook(Method hook) {
        this.hook = hook;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HookModel)) {
            return false;
        }
        HookModel other = (HookModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<JoinPoint> this$includes = this.getIncludes();
        List<JoinPoint> other$includes = other.getIncludes();
        if (this$includes == null ? other$includes != null : !((Object)this$includes).equals(other$includes)) {
            return false;
        }
        List<JoinPoint> this$excludes = this.getExcludes();
        List<JoinPoint> other$excludes = other.getExcludes();
        if (this$excludes == null ? other$excludes != null : !((Object)this$excludes).equals(other$excludes)) {
            return false;
        }
        Method this$hook = this.getHook();
        Method other$hook = other.getHook();
        return !(this$hook == null ? other$hook != null : !((Object)this$hook).equals(other$hook));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HookModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<JoinPoint> $includes = this.getIncludes();
        result = result * 59 + ($includes == null ? 43 : ((Object)$includes).hashCode());
        List<JoinPoint> $excludes = this.getExcludes();
        result = result * 59 + ($excludes == null ? 43 : ((Object)$excludes).hashCode());
        Method $hook = this.getHook();
        result = result * 59 + ($hook == null ? 43 : ((Object)$hook).hashCode());
        return result;
    }

    public String toString() {
        return "HookModel(includes=" + this.getIncludes() + ", excludes=" + this.getExcludes() + ", hook=" + this.getHook() + ")";
    }

    private class JoinPoint {
        private String className;
        private boolean classWildcard = false;
        private String methodName;
        private boolean methodWildcard = false;

        JoinPoint(String desc) {
            String[] classAndMethod = desc.split("#");
            this.className = classAndMethod[0];
            if (this.className.endsWith("*")) {
                this.className = this.className.substring(0, this.className.length() - 1);
                this.classWildcard = true;
            }
            if (classAndMethod.length >= 2) {
                this.methodName = classAndMethod[1];
                if (this.methodName.endsWith("*")) {
                    this.methodName = this.methodName.substring(0, this.methodName.length() - 1);
                    this.methodWildcard = true;
                }
            } else {
                this.methodName = "";
                this.methodWildcard = true;
            }
        }

        boolean matchesClass(String targetClassName) {
            if (this.classWildcard) {
                return targetClassName.startsWith(this.className);
            }
            return targetClassName.equals(this.className);
        }

        boolean matchesMethod(String targetClassName, String targetMethodName) {
            if (!this.matchesClass(targetClassName)) {
                return false;
            }
            if (this.methodWildcard) {
                return targetMethodName.startsWith(this.methodName);
            }
            return targetMethodName.equals(this.methodName);
        }

        public String getClassName() {
            return this.className;
        }

        public boolean isClassWildcard() {
            return this.classWildcard;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public boolean isMethodWildcard() {
            return this.methodWildcard;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setClassWildcard(boolean classWildcard) {
            this.classWildcard = classWildcard;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public void setMethodWildcard(boolean methodWildcard) {
            this.methodWildcard = methodWildcard;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JoinPoint)) {
                return false;
            }
            JoinPoint other = (JoinPoint)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            if (this.isClassWildcard() != other.isClassWildcard()) {
                return false;
            }
            String this$methodName = this.getMethodName();
            String other$methodName = other.getMethodName();
            if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
                return false;
            }
            return this.isMethodWildcard() == other.isMethodWildcard();
        }

        protected boolean canEqual(Object other) {
            return other instanceof JoinPoint;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            result = result * 59 + (this.isClassWildcard() ? 79 : 97);
            String $methodName = this.getMethodName();
            result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
            result = result * 59 + (this.isMethodWildcard() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "HookModel.JoinPoint(className=" + this.getClassName() + ", classWildcard=" + this.isClassWildcard() + ", methodName=" + this.getMethodName() + ", methodWildcard=" + this.isMethodWildcard() + ")";
        }
    }
}

