/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.aop;

import cn.imaq.autumn.aop.HookModel;
import cn.imaq.autumn.core.context.AutumnContext;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;

public class AopContext {
    public static final String ATTR = AopContext.class.getName();
    private Queue<HookModel> hooks = new ConcurrentLinkedQueue<HookModel>();

    private AopContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AopContext getFrom(AutumnContext context) {
        AopContext aopContext = (AopContext)context.getAttribute(ATTR);
        if (aopContext == null) {
            AutumnContext autumnContext = context;
            synchronized (autumnContext) {
                aopContext = (AopContext)context.getAttribute(ATTR);
                if (aopContext == null) {
                    aopContext = new AopContext();
                    context.setAttribute(ATTR, (Object)aopContext);
                }
            }
        }
        return aopContext;
    }

    public void addHook(HookModel model) {
        this.hooks.add(model);
    }

    public List<HookModel> getHooksForClass(Class<?> clazz) {
        return this.hooks.stream().filter(hm -> hm.matches(clazz)).collect(Collectors.toList());
    }
}

