package cn.edu.tsinghua.tsfile.timeseries.utils;

import java.io.File;

/**
 * FileUtils is just used for return file attribute like file size, and contains
 * some measurement conversion among B, KB, MB etc.
 *
 * @author kangrong
 */
public class FileUtils {

    public static double getLocalFileByte(String filePath, Unit unit) {
        File f = new File(filePath);
        return getLocalFileByte(f, unit);
    }

    public static double getLocalFileByte(File file, Unit unit) {
        return format(transformUnit(file.length(), unit), 2);
    }

    /**
     * transform the byte value number to another unit.
     *
     * @param value - a number represented Byte which to be transformed
     * @param unit  - the target unit to be transformed
     * @return - value number in unit of given parameter
     */
    public static double transformUnit(double value, Unit unit) {
        return value / Math.pow(1024, unit.ordinal());
    }

    /**
     * transform the value number from other unit to Byte unit.
     *
     * @param value - a number to be transformed
     * @param unit  - the source unit to be transformed, maybe in unit of KB, MB,
     *              GB
     * @return - value number in unit of Byte
     */
    public static double transformUnitToByte(double value, Unit unit) {
        return value * Math.pow(1024, unit.ordinal());
    }

    /**
     * reserves some decimal for given double value
     *
     * @param num   - given double value
     * @param round - reserved decimal number
     * @return - double value in given decimal number
     */
    public static double format(double num, int round) {
        long a = (long) (num * Math.pow(10, round));
        return ((double) a) / Math.pow(10, round);
    }

    public static enum Unit {
        B, KB, MB, GB, TB, PB, EB
    }
}
