/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easycommons.commondao;

import cn.easyproject.easycommons.commondao.CommonDAO;
import cn.easyproject.easycommons.commondao.util.EasyCriteria;
import cn.easyproject.easycommons.commondao.util.PageBean;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.jdbc.Work;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository(value="commonDAO")
public class CommonDAOSpringImpl
implements CommonDAO {
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public void batchUpdateSQL(final String sql, final Object[] values) {
        ((Session)this.entityManager.unwrap(Session.class)).doWork(new Work(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection connection) throws SQLException {
                Statement pstmt = null;
                try {
                    connection.setAutoCommit(false);
                    pstmt = connection.prepareStatement(sql);
                    for (int i = 0; i < values.length; ++i) {
                        pstmt.setObject(1, values[i]);
                        pstmt.addBatch();
                    }
                    pstmt.executeBatch();
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void batchUpdateSQL(final String sql, final Object[][] values) {
        ((Session)this.entityManager.unwrap(Session.class)).doWork(new Work(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection connection) throws SQLException {
                Statement pstmt = null;
                try {
                    connection.setAutoCommit(false);
                    pstmt = connection.prepareStatement(sql);
                    for (Object[] row : values) {
                        for (int i = 0; i < row.length; ++i) {
                            pstmt.setObject(i + 1, row[i]);
                        }
                        pstmt.addBatch();
                    }
                    pstmt.executeBatch();
                    connection.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private Query createNamedQuery(EntityManager entityManager, String name, boolean cacheable, String cacheRegion, Map<String, Object> values) {
        Query query = entityManager.createNamedQuery(name.trim());
        if (cacheable) {
            query.setHint("org.hibernate.cacheable", (Object)"true");
            if (cacheRegion != null && !cacheRegion.equals("")) {
                query.setHint("org.hibernate.cacheRegion", (Object)cacheRegion);
            }
        }
        if (values != null && values.size() > 0) {
            for (Map.Entry<String, Object> e : values.entrySet()) {
                query.setParameter(e.getKey(), e.getValue());
            }
        }
        return query;
    }

    private Query createNativeQuery(EntityManager entityManager, String sql, Class resultClass, boolean mapResult, Map<String, Object> values) {
        Query query = null;
        query = resultClass != null ? entityManager.createNativeQuery(sql, resultClass) : entityManager.createNativeQuery(sql);
        if (mapResult) {
            ((org.hibernate.Query)query.unwrap(org.hibernate.Query.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        }
        if (values != null && values.size() > 0) {
            for (Map.Entry<String, Object> e : values.entrySet()) {
                query.setParameter(e.getKey(), e.getValue());
            }
        }
        return query;
    }

    private Query createQuery(EntityManager entityManager, String jpql, boolean cacheable, String cacheRegion, Map<String, Object> values) {
        Query query = entityManager.createQuery(jpql);
        if (cacheable) {
            query.setHint("org.hibernate.cacheable", (Object)"true");
            if (cacheRegion != null && !cacheRegion.equals("")) {
                query.setHint("org.hibernate.cacheRegion", (Object)cacheRegion);
            }
        }
        if (values != null && values.size() > 0) {
            for (Map.Entry<String, Object> e : values.entrySet()) {
                query.setParameter(e.getKey(), e.getValue());
            }
        }
        return query;
    }

    @Override
    public void delete(Class clazz, Serializable id) {
        this.entityManager.remove(this.entityManager.find(clazz, (Object)id));
    }

    @Override
    public void delete(Object o) {
        this.entityManager.remove(o);
    }

    @Override
    public Integer deleteByValues(Class cls, String idFieldName, String[] values) {
        int res = 0;
        StringBuilder ins = new StringBuilder();
        ins.append("'");
        for (String v : values) {
            ins.append(v).append("','");
        }
        String jpql = "delete from " + cls.getSimpleName() + " where " + idFieldName + " in(" + ins.substring(0, ins.length() - 2) + ")";
        res = this.entityManager.createQuery(jpql).executeUpdate();
        return res;
    }

    @Override
    public void deleteCascadeByValues(Class cls, String fieldName, String[] values) {
        StringBuilder ins = new StringBuilder();
        ins.append("'");
        for (String v : values) {
            ins.append(v).append("','");
        }
        String jpql = "from " + cls.getSimpleName() + " where " + fieldName + " in(" + ins.substring(0, ins.length() - 2) + ")";
        for (Object o : this.entityManager.createQuery(jpql).getResultList()) {
            this.entityManager.remove(o);
        }
    }

    @Override
    public void evict(Class c) {
        this.entityManager.getEntityManagerFactory().getCache().evict(c);
    }

    @Override
    public void evict(Class c, Serializable id) {
        this.entityManager.getEntityManagerFactory().getCache().evict(c, (Object)id);
    }

    @Override
    public void evictAll() {
        this.entityManager.getEntityManagerFactory().getCache().evictAll();
    }

    @Override
    public void evictCollectionRegion(String collectionRegion) {
        ((SessionFactory)this.entityManager.unwrap(SessionFactory.class)).getCache().evictCollectionRegion(collectionRegion);
    }

    @Override
    public void evictCollectionRegion(String collectionRegion, Serializable id) {
        ((SessionFactory)this.entityManager.unwrap(SessionFactory.class)).getCache().evictCollection(collectionRegion, id);
    }

    @Override
    public void evictQueries() {
        if (null != "org.hibernate.cache.internal.StandardQueryCache" || !"".equals("org.hibernate.cache.internal.StandardQueryCache")) {
            ((SessionFactory)this.entityManager.unwrap(SessionFactory.class)).getCache().evictQueryRegion("org.hibernate.cache.internal.StandardQueryCache");
        } else {
            ((SessionFactory)this.entityManager.unwrap(SessionFactory.class)).getCache().evictQueryRegions();
        }
    }

    @Override
    public void evictQueries(String queryCacheRegion) {
        ((SessionFactory)this.entityManager.unwrap(SessionFactory.class)).getCache().evictQueryRegion(queryCacheRegion);
    }

    @Override
    public List find(String jpql) {
        return this.find(jpql, new HashMap<String, Object>());
    }

    @Override
    public List find(String jpql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.find(jpql + " " + easyCriteria.getCondition(), easyCriteria.getValues());
        }
        return this.find(jpql, new HashMap<String, Object>());
    }

    @Override
    public List find(String jpql, Map<String, Object> values) {
        Query q = this.createQuery(this.entityManager, jpql, false, null, values);
        List list = q.getResultList();
        return list;
    }

    @Override
    public List findAll(Class cls) {
        String queryString = "from " + cls.getName();
        List list = this.entityManager.createQuery(queryString).getResultList();
        this.initialize(list);
        return list;
    }

    @Override
    public List findByCache(String jpql) {
        return this.findByCache(jpql, new HashMap<String, Object>());
    }

    @Override
    public List findByCache(String jpql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findByCache(jpql + " " + easyCriteria.getCondition(), easyCriteria.getValues());
        }
        return this.findByCache(jpql, new HashMap<String, Object>());
    }

    @Override
    public List findByCache(String jpql, Map<String, Object> values) {
        String cacheRegion = null;
        if (null != "org.hibernate.cache.internal.StandardQueryCache" || !"".equals("org.hibernate.cache.internal.StandardQueryCache")) {
            cacheRegion = "org.hibernate.cache.internal.StandardQueryCache";
        }
        Query q = this.createQuery(this.entityManager, jpql, true, cacheRegion, values);
        List list = q.getResultList();
        return list;
    }

    @Override
    public List findByCache(String jpql, String queryCacheRegion, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findByCache(jpql + " " + easyCriteria.getCondition(), queryCacheRegion, easyCriteria.getValues());
        }
        return this.findByCache(jpql, queryCacheRegion, new HashMap<String, Object>());
    }

    @Override
    public List findByCache(String jpql, String queryCacheRegion) {
        return this.findByCache(jpql, queryCacheRegion, new HashMap<String, Object>());
    }

    @Override
    public List findByCache(String jpql, String queryCacheRegion, Map<String, Object> values) {
        Query q = this.createQuery(this.entityManager, jpql, true, queryCacheRegion, values);
        List list = q.getResultList();
        return list;
    }

    @Override
    public void findByPage(PageBean pageBean) {
        this.findByPage(pageBean, new HashMap<String, Object>());
    }

    @Override
    public void findByPage(PageBean pageBean, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            pageBean.setCondition(easyCriteria.getCondition());
            this.findByPage(pageBean, easyCriteria.getValues());
        } else {
            this.findByPage(pageBean);
        }
    }

    @Override
    public void findByPage(PageBean pageBean, Map<String, Object> values) {
        String jpql = pageBean.getQuery() != null ? pageBean.getQuery() : pageBean.getAutoQuery();
        Query query = this.createQuery(this.entityManager, jpql, false, null, values);
        query.setFirstResult(pageBean.getRowStart());
        query.setMaxResults(pageBean.getRowsPerPage());
        pageBean.setData(query.getResultList());
        String queryString = "";
        int end = jpql.length();
        if (jpql.indexOf("order by") != -1) {
            end = jpql.indexOf("order by");
        }
        if (jpql.toUpperCase().indexOf("SELECT") != -1) {
            int i = jpql.toUpperCase().indexOf("FROM");
            queryString = "select count(1) " + jpql.substring(i, end);
        } else {
            queryString = "select count(1) " + jpql.substring(0, end);
        }
        int j = queryString.toUpperCase().lastIndexOf("ORDER");
        if (j != -1) {
            queryString = queryString.substring(0, j);
        }
        Query cquery = this.createQuery(this.entityManager, queryString, false, null, values);
        int maxRow = Integer.valueOf(cquery.getSingleResult().toString());
        pageBean.setRowsCount(maxRow);
    }

    @Override
    public List findByProperty(Class cls, String propertyName, Object value) {
        String queryString = "from " + cls.getName() + " model where model." + propertyName + "= :propetyName";
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("propetyName", value);
        return this.find(queryString, values);
    }

    @Override
    public List findByPropertyIgnoreCase(Class cls, String propertyName, String value) {
        String queryString = "from " + cls.getName() + " model where lower(model." + propertyName + ")= :propetyName";
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("propetyName", value);
        return this.find(queryString, values);
    }

    @Override
    public List findBySQL(String sql, Class resultClass) {
        return this.findBySQL(sql, resultClass, new HashMap<String, Object>());
    }

    @Override
    public List findBySQL(String sql, Class resultClass, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findBySQL(sql + " " + easyCriteria.getCondition(), resultClass, easyCriteria.getValues());
        }
        return this.findBySQL(sql, resultClass, new HashMap<String, Object>());
    }

    @Override
    public List findBySQL(String sql, Class resultClass, Map<String, Object> values) {
        Query q = this.createNativeQuery(this.entityManager, sql, resultClass, false, values);
        List list = q.getResultList();
        return list;
    }

    @Override
    public List findBySQL(String sql) {
        return this.findBySQL(sql, new HashMap<String, Object>());
    }

    @Override
    public List findBySQL(String sql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findBySQL(sql + " " + easyCriteria.getCondition(), easyCriteria.getValues());
        }
        return this.findBySQL(sql, new HashMap<String, Object>());
    }

    @Override
    public List findBySQL(String sql, Map<String, Object> values) {
        Query q = this.createNativeQuery(this.entityManager, sql, null, false, values);
        List list = q.getResultList();
        return list;
    }

    @Override
    public int findCount(String jpql) {
        return this.findCount(jpql, new HashMap<String, Object>());
    }

    @Override
    public int findCount(String jpql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findCount(jpql + " " + easyCriteria.getCondition(), easyCriteria.getValues());
        }
        return this.findCount(jpql, new HashMap<String, Object>());
    }

    @Override
    public int findCount(String jpql, Map<String, Object> values) {
        Query q = this.createQuery(this.entityManager, jpql, false, null, values);
        return Integer.valueOf(q.getSingleResult().toString());
    }

    @Override
    public List findMapResultBySQL(String sql) {
        return this.findMapResultBySQL(sql, new HashMap<String, Object>());
    }

    @Override
    public List findMapResultBySQL(String sql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findMapResultBySQL(sql + " " + easyCriteria.getCondition(), easyCriteria.getValues());
        }
        return this.findMapResultBySQL(sql, new HashMap<String, Object>());
    }

    @Override
    public List findMapResultBySQL(String sql, Map<String, Object> values) {
        Query q = this.createNativeQuery(this.entityManager, sql, null, true, values);
        List list = q.getResultList();
        return list;
    }

    @Override
    public int findMaxPage(String jpql, int rowsPerPage) {
        return (this.findCount(jpql, new HashMap<String, Object>()) - 1) / rowsPerPage + 1;
    }

    @Override
    public int findMaxPage(String jpql, int rowsPerPage, EasyCriteria easyCriteria) {
        return (this.findCount(jpql, easyCriteria) - 1) / rowsPerPage + 1;
    }

    @Override
    public int findMaxPage(String jpql, int rowsPerPage, Map<String, Object> values) {
        return (this.findCount(jpql, values) - 1) / rowsPerPage + 1;
    }

    @Override
    public List findNamedQuery(String name) {
        Query q = this.createNamedQuery(this.entityManager, name, false, null, new HashMap<String, Object>());
        return q.getResultList();
    }

    @Override
    public List findNamedQuery(String name, Map<String, Object> values) {
        Query q = this.createNamedQuery(this.entityManager, name, false, null, values);
        return q.getResultList();
    }

    @Override
    public List findNamedQueryByCache(String name, String queryCacheRegion, Map<String, Object> values) {
        Query q = this.createNamedQuery(this.entityManager, name, true, queryCacheRegion, values);
        return q.getResultList();
    }

    @Override
    public List findTop(String jpql, int topCount) {
        return this.findTop(jpql, topCount, new HashMap<String, Object>());
    }

    @Override
    public List findTop(String jpql, int topCount, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findTop(jpql + " " + easyCriteria.getCondition(), topCount, easyCriteria.getValues());
        }
        return this.findTop(jpql, topCount, new HashMap<String, Object>());
    }

    @Override
    public List findTop(String jpql, int topCount, Map<String, Object> values) {
        Query query = this.entityManager.createQuery(jpql);
        query.setFirstResult(0);
        query.setMaxResults(topCount);
        if (values != null && values.size() > 0) {
            for (Map.Entry<String, Object> e : values.entrySet()) {
                query.setParameter(e.getKey(), e.getValue());
            }
        }
        List list = query.getResultList();
        return list;
    }

    @Override
    public <T> T findVal(String jpql) {
        List list = this.find(jpql, new HashMap<String, Object>());
        return list.size() > 0 ? (T)list.get(0) : null;
    }

    @Override
    public <T> T findVal(String jpql, EasyCriteria easyCriteria) {
        List list = this.find(jpql, easyCriteria);
        return list.size() > 0 ? (T)list.get(0) : null;
    }

    @Override
    public <T> T findVal(String jpql, Map<String, Object> values) {
        List list = this.find(jpql, values);
        return list.size() > 0 ? (T)list.get(0) : null;
    }

    @Override
    public <T> T find(Class clazz, Serializable id) {
        return (T)this.entityManager.find(clazz, (Object)id);
    }

    @Override
    public EntityManager getCurrentEntityManager() {
        return this.entityManager;
    }

    @Override
    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManager.getEntityManagerFactory();
    }

    @Override
    public void initialize(Object proxy) {
        if (!Hibernate.isInitialized((Object)proxy)) {
            Hibernate.initialize((Object)proxy);
        }
    }

    @Override
    public void initializeDeep(Collection collection) {
        if (collection == null) {
            return;
        }
        for (Object obj : collection) {
            Method[] methods = obj.getClass().getMethods();
            if (methods == null) continue;
            for (int j = 0; j < methods.length; ++j) {
                String getName = methods[j].getName();
                if (getName.length() <= 3 || !getName.startsWith("get")) continue;
                String getFix = getName.substring(3, getName.length());
                for (int k = 0; k < methods.length; ++k) {
                    String setFix;
                    String setName = methods[k].getName();
                    if (setName.length() <= 3 || !setName.startsWith("set") || !getFix.equals(setFix = setName.substring(3, setName.length()))) continue;
                    try {
                        Object o = methods[j].invoke(obj, new Object[0]);
                        if (o == null) continue;
                        Hibernate.initialize((Object)o);
                        methods[k].invoke(obj, o);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void merge(Object o) {
        this.entityManager.merge(o);
    }

    @Override
    public void persist(Object o) {
        this.entityManager.persist(o);
    }

    @Override
    public void updateByJpql(String jpql) {
        this.updateByJpql(jpql, new HashMap<String, Object>());
    }

    @Override
    public void updateByJpql(String jpql, Map<String, Object> values) {
        Query query = this.entityManager.createQuery(jpql);
        if (values != null && values.size() > 0) {
            for (Map.Entry<String, Object> e : values.entrySet()) {
                query.setParameter(e.getKey(), e.getValue());
            }
        }
        query.executeUpdate();
    }

    @Override
    public void updateBySQL(String sql) {
        this.updateBySQL(sql, new HashMap<String, Object>());
    }

    @Override
    public void updateBySQL(String sql, Map<String, Object> values) {
        Query query = this.entityManager.createNativeQuery(sql);
        if (values != null && values.size() > 0) {
            for (Map.Entry<String, Object> e : values.entrySet()) {
                query.setParameter(e.getKey(), e.getValue());
            }
        }
        query.executeUpdate();
    }
}

