/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easycommons.commondao;

import cn.easyproject.easycommons.commondao.CommonDAO;
import cn.easyproject.easycommons.commondao.factory.JPAEntityManagerFactory;
import cn.easyproject.easycommons.commondao.util.EasyCriteria;
import cn.easyproject.easycommons.commondao.util.PageBean;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository(value="commonDAO")
public class CommonDAOSpringImpl
implements CommonDAO {
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public void batchUpdateSQL(final String sql, final Object[] values) {
        ((Session)this.entityManager.unwrap(Session.class)).doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                block18: {
                    Statement pstmt = null;
                    try {
                        try {
                            connection.setAutoCommit(false);
                            pstmt = connection.prepareStatement(sql);
                            int i = 0;
                            while (i < values.length) {
                                pstmt.setObject(1, values[i]);
                                pstmt.addBatch();
                                ++i;
                            }
                            pstmt.executeBatch();
                            connection.commit();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (pstmt != null) {
                                try {
                                    pstmt.close();
                                }
                                catch (SQLException e2) {
                                    e2.printStackTrace();
                                }
                            }
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        if (pstmt != null) {
                            try {
                                pstmt.close();
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                        }
                        throw throwable;
                    }
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void batchUpdateSQL(final String sql, final Object[][] values) {
        ((Session)this.entityManager.unwrap(Session.class)).doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                PreparedStatement pstmt = connection.prepareStatement(sql);
                Object[][] objectArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    Object[] row = objectArray[n2];
                    int i = 0;
                    while (i < row.length) {
                        pstmt.setObject(i + 1, row[i]);
                        ++i;
                    }
                    pstmt.addBatch();
                    ++n2;
                }
                pstmt.executeBatch();
            }
        });
    }

    private Query createNamedQuery(EntityManager entityManager, String name, boolean cacheable, String cacheRegion, Object ... values) {
        Query query = entityManager.createNamedQuery(name.trim());
        if (cacheable) {
            query.setHint("org.hibernate.cacheable", (Object)"true");
            if (cacheRegion != null && !cacheRegion.equals("")) {
                query.setHint("org.hibernate.cacheRegion", (Object)cacheRegion);
            }
        }
        if (values != null && values.length > 0) {
            int i = 0;
            while (i < values.length) {
                query.setParameter(i + 1, values[i]);
                ++i;
            }
        }
        return query;
    }

    private Query createNativeQuery(EntityManager entityManager, String sql, Class resultClass, boolean mapResult, Object ... values) {
        Query query = null;
        query = resultClass != null ? entityManager.createNativeQuery(sql, resultClass) : entityManager.createNativeQuery(sql);
        if (mapResult) {
            ((org.hibernate.Query)query.unwrap(org.hibernate.Query.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        }
        if (values != null && values.length > 0) {
            int i = 0;
            while (i < values.length) {
                query.setParameter(i + 1, values[i]);
                ++i;
            }
        }
        return query;
    }

    private Query createQuery(EntityManager entityManager, String jpql, boolean cacheable, String cacheRegion, Object ... values) {
        Query query = entityManager.createQuery(jpql);
        if (cacheable) {
            query.setHint("org.hibernate.cacheable", (Object)"true");
            if (cacheRegion != null && !cacheRegion.equals("")) {
                query.setHint("org.hibernate.cacheRegion", (Object)cacheRegion);
            }
        }
        if (values != null && values.length > 0) {
            int i = 0;
            while (i < values.length) {
                query.setParameter(i, values[i]);
                ++i;
            }
        }
        return query;
    }

    @Override
    public void remove(Class cls, Serializable id) {
        this.entityManager.remove(this.entityManager.find(cls, (Object)id));
    }

    @Override
    public void remove(Object o) {
        this.entityManager.remove(o);
    }

    @Override
    public Integer deleteByValues(Class cls, String fieldName, Object[] values) {
        StringBuilder ins = new StringBuilder();
        ins.append("'");
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object v = objectArray[n2];
            ins.append(v).append("','");
            ++n2;
        }
        String jpql = "delete from " + cls.getSimpleName() + " where " + fieldName + " in(" + ins.substring(0, ins.length() - 2) + ")";
        return this.entityManager.createQuery(jpql).executeUpdate();
    }

    @Override
    public void deleteCascadeByValues(Class cls, String fieldName, Object[] values) {
        StringBuilder ins = new StringBuilder();
        ins.append("'");
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object v = objectArray[n2];
            ins.append(v).append("','");
            ++n2;
        }
        String jpql = "from " + cls.getSimpleName() + " where " + fieldName + " in(" + ins.substring(0, ins.length() - 2) + ")";
        for (Object o : this.entityManager.createQuery(jpql).getResultList()) {
            this.entityManager.remove(o);
        }
    }

    @Override
    public void evict(Class cls) {
        this.entityManager.getEntityManagerFactory().getCache().evict(cls);
    }

    @Override
    public void evict(Class cls, Serializable id) {
        this.entityManager.getEntityManagerFactory().getCache().evict(cls, (Object)id);
    }

    @Override
    public void evictAll() {
        this.entityManager.getEntityManagerFactory().getCache().evictAll();
    }

    @Override
    public void evictCollectionRegion(String collectionRegion) {
        ((Session)JPAEntityManagerFactory.getEntityManager().unwrap(Session.class)).getSessionFactory().getCache().evictCollectionRegion(collectionRegion);
    }

    @Override
    public void evictCollectionRegion(String collectionRegion, Serializable id) {
        ((Session)JPAEntityManagerFactory.getEntityManager().unwrap(Session.class)).getSessionFactory().getCache().evictCollection(collectionRegion, id);
    }

    @Override
    public void evictQueries() {
        if ("org.hibernate.cache.internal.StandardQueryCache" != null || !"".equals("org.hibernate.cache.internal.StandardQueryCache")) {
            ((Session)JPAEntityManagerFactory.getEntityManager().unwrap(Session.class)).getSessionFactory().getCache().evictQueryRegion("org.hibernate.cache.internal.StandardQueryCache");
        } else {
            ((Session)JPAEntityManagerFactory.getEntityManager().unwrap(Session.class)).getSessionFactory().getCache().evictQueryRegions();
        }
    }

    @Override
    public void evictQueries(String queryCacheRegion) {
        ((Session)JPAEntityManagerFactory.getEntityManager().unwrap(Session.class)).getSessionFactory().getCache().evictQueryRegion(queryCacheRegion);
    }

    @Override
    public List find(String jpql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.find(String.valueOf(jpql) + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
        }
        return this.find(jpql, new Object[0]);
    }

    @Override
    public List find(String jpql, Object ... values) {
        Query q = this.createQuery(this.entityManager, jpql, false, null, values);
        List list = q.getResultList();
        return list;
    }

    @Override
    public List findAll(Class cls) {
        String queryString = "from " + cls.getName();
        List list = this.entityManager.createQuery(queryString).getResultList();
        this.initialize(list);
        return list;
    }

    @Override
    public List findByCache(String jpql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findByCache(String.valueOf(jpql) + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
        }
        return this.findByCache(jpql, new Object[0]);
    }

    @Override
    public List findByCache(String jpql, Object ... values) {
        String cacheRegion = null;
        if ("org.hibernate.cache.internal.StandardQueryCache" != null || !"".equals("org.hibernate.cache.internal.StandardQueryCache")) {
            cacheRegion = "org.hibernate.cache.internal.StandardQueryCache";
        }
        Query q = this.createQuery(this.entityManager, jpql, true, cacheRegion, values);
        List list = q.getResultList();
        return list;
    }

    @Override
    public List findByCache(String jpql, String queryCacheRegion, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findByCache(String.valueOf(jpql) + " " + easyCriteria.getCondition(), queryCacheRegion, easyCriteria.getValues().toArray());
        }
        return this.findByCache(jpql, queryCacheRegion, new Object[0]);
    }

    @Override
    public List findByCache(String jpql, String queryCacheRegion, Object ... values) {
        Query q = this.createQuery(this.entityManager, jpql, true, queryCacheRegion, values);
        List list = q.getResultList();
        return list;
    }

    @Override
    public void findByPage(PageBean pageBean) {
        this.findByPage(pageBean, new ArrayList());
    }

    @Override
    public void findByPage(PageBean pageBean, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            pageBean.setCondition(easyCriteria.getCondition());
            this.findByPage(pageBean, easyCriteria.getValues());
        } else {
            this.findByPage(pageBean);
        }
    }

    @Override
    public void findByPage(PageBean pageBean, List values) {
        String jpql = pageBean.getAutoQuery();
        Query query = this.createQuery(this.entityManager, jpql, false, null, values.toArray());
        query.setFirstResult(pageBean.getRowStart());
        query.setMaxResults(pageBean.getRowsPerPage());
        pageBean.setData(query.getResultList());
        Query cquery = this.createQuery(this.entityManager, pageBean.getAutoCountQuery(), false, null, values.toArray());
        int maxRow = Integer.valueOf(cquery.getSingleResult().toString());
        pageBean.setRowsCount(maxRow);
    }

    @Override
    public List findByProperty(Class cls, String propertyName, Object value) {
        String queryString = "from " + cls.getName() + " model where model." + propertyName + "= ?";
        return this.find(queryString, value);
    }

    @Override
    public List findByPropertyIgnoreCase(Class cls, String propertyName, String value) {
        String queryString = "from " + cls.getName() + " model where lower(model." + propertyName + ")= ?";
        return this.find(queryString, value.toLowerCase());
    }

    @Override
    public List findBySQL(String sql, Class resultClass, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findBySQL(String.valueOf(sql) + " " + easyCriteria.getCondition(), resultClass, easyCriteria.getValues().toArray());
        }
        return this.findBySQL(sql, resultClass, new Object[0]);
    }

    @Override
    public List findBySQL(String sql, Class resultClass, Object ... values) {
        Query q = this.createNativeQuery(this.entityManager, sql, resultClass, false, values);
        List list = q.getResultList();
        return list;
    }

    @Override
    public List findBySQL(String sql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findBySQL(String.valueOf(sql) + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
        }
        return this.findBySQL(sql, new Object[0]);
    }

    @Override
    public List findBySQL(String sql, Object ... values) {
        Query q = this.createNativeQuery(this.entityManager, sql, null, false, values);
        List list = q.getResultList();
        return list;
    }

    @Override
    public int findCount(String jpql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findCount(String.valueOf(jpql) + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
        }
        return this.findCount(jpql, new Object[0]);
    }

    @Override
    public int findCount(String jpql, Object ... values) {
        Query q = this.createQuery(this.entityManager, jpql, false, null, values);
        return Integer.valueOf(q.getSingleResult().toString());
    }

    @Override
    public List findMapResultBySQL(String sql, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findMapResultBySQL(String.valueOf(sql) + " " + easyCriteria.getCondition(), easyCriteria.getValues().toArray());
        }
        return this.findMapResultBySQL(sql, new Object[0]);
    }

    @Override
    public List findMapResultBySQL(String sql, Object ... values) {
        Query q = this.createNativeQuery(this.entityManager, sql, null, true, values);
        List list = q.getResultList();
        return list;
    }

    @Override
    public int findMaxPage(String jpql, int rowsPerPage, EasyCriteria easyCriteria) {
        return (this.findCount(jpql, easyCriteria) - 1) / rowsPerPage + 1;
    }

    @Override
    public int findMaxPage(String jpql, int rowsPerPage, Object ... values) {
        return (this.findCount(jpql, values) - 1) / rowsPerPage + 1;
    }

    @Override
    public List findNamedQuery(String name, Object ... values) {
        Query q = this.createNamedQuery(this.entityManager, name, false, null, values);
        return q.getResultList();
    }

    @Override
    public List findNamedQueryByCache(String name, String queryCacheRegion, Object ... values) {
        Query q = this.createNamedQuery(this.entityManager, name, true, queryCacheRegion, values);
        return q.getResultList();
    }

    @Override
    public List findTop(String jpql, int topCount, EasyCriteria easyCriteria) {
        if (easyCriteria != null) {
            return this.findTop(String.valueOf(jpql) + " " + easyCriteria.getCondition(), topCount, easyCriteria.getValues().toArray());
        }
        return this.findTop(jpql, topCount, new Object[0]);
    }

    @Override
    public List findTop(String jpql, int topCount, Object ... values) {
        Query q = this.entityManager.createQuery(jpql);
        q.setFirstResult(0);
        q.setMaxResults(topCount);
        if (values != null && values.length > 0) {
            int i = 0;
            while (i < values.length) {
                q.setParameter(i, values[i]);
                ++i;
            }
        }
        List list = q.getResultList();
        return list;
    }

    @Override
    public <T> T findVal(String jpql, EasyCriteria easyCriteria) {
        List list = this.find(jpql, easyCriteria);
        return list.size() > 0 ? (T)list.get(0) : null;
    }

    @Override
    public <T> T findVal(String jpql, Object ... values) {
        List list = this.find(jpql, values);
        return list.size() > 0 ? (T)list.get(0) : null;
    }

    @Override
    public <T> T find(Class cls, Serializable id) {
        return (T)this.entityManager.find(cls, (Object)id);
    }

    @Override
    public EntityManager getCurrentEntityManager() {
        return this.entityManager;
    }

    @Override
    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManager.getEntityManagerFactory();
    }

    @Override
    public void initialize(Object proxy) {
        if (!Hibernate.isInitialized((Object)proxy)) {
            Hibernate.initialize((Object)proxy);
        }
    }

    @Override
    public void initializeDeep(Collection collection) {
        if (collection == null) {
            return;
        }
        for (Object obj : collection) {
            Method[] methods = obj.getClass().getMethods();
            if (methods == null) continue;
            int j = 0;
            while (j < methods.length) {
                String getName = methods[j].getName();
                if (getName.length() > 3 && getName.startsWith("get")) {
                    String getFix = getName.substring(3, getName.length());
                    int k = 0;
                    while (k < methods.length) {
                        String setFix;
                        String setName = methods[k].getName();
                        if (setName.length() > 3 && setName.startsWith("set") && getFix.equals(setFix = setName.substring(3, setName.length()))) {
                            try {
                                Object o = methods[j].invoke(obj, new Object[0]);
                                if (o != null) {
                                    Hibernate.initialize((Object)o);
                                    methods[k].invoke(obj, o);
                                }
                            }
                            catch (IllegalArgumentException e) {
                                e.printStackTrace();
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                        }
                        ++k;
                    }
                }
                ++j;
            }
        }
    }

    @Override
    public void merge(Object o) {
        this.entityManager.merge(o);
    }

    @Override
    public void persist(Object o) {
        this.entityManager.persist(o);
    }

    @Override
    public void updateByJpql(String jpql, Object ... values) {
        Query query = this.entityManager.createQuery(jpql);
        if (values != null && values.length > 0) {
            int i = 0;
            while (i < values.length) {
                query.setParameter(i, values[i]);
                ++i;
            }
        }
        query.executeUpdate();
    }

    @Override
    public void updateBySQL(String sql, Object ... values) {
        Query query = this.entityManager.createNativeQuery(sql);
        if (values != null && values.length > 0) {
            int i = 0;
            while (i < values.length) {
                query.setParameter(i + 1, values[i]);
                ++i;
            }
        }
        query.executeUpdate();
    }
}

