package cn.easyproject.easybackup.job;

import java.io.IOException;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.scheduling.quartz.QuartzJobBean;

import cn.easyproject.easybackup.backup.StdBackupEngine;
import cn.easyproject.easybackup.configuration.GlobalConfiguration;
import cn.easyproject.easybackup.util.SpringUtil;


/**
 * Auto reload the backup job when easybackup.properties update
 * @author easyproject.cn
 *
 * @since 1.0.0
 */
public class ReloadConfigurationJob extends QuartzJobBean {

	static Logger logger=LoggerFactory.getLogger(ReloadConfigurationJob.class);
	
	public static long propertiesLastModify;
	
	@Override
	protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
		// 检测配置文件是否修改
		ResourceLoader rl=new PathMatchingResourcePatternResolver();
		Resource res = rl.getResource("file:easybackup.properties");
		
		if(res.exists()){
			try {
				long lastModify=res.getFile().lastModified();
				// 如果配置文件被修改，则停止所有任务，重新加载		
				if(lastModify!=ReloadConfigurationJob.propertiesLastModify){
					GlobalConfiguration.properties.load(res.getInputStream());
					ReloadConfigurationJob.propertiesLastModify=lastModify;
					
					JobManager jobManager = SpringUtil.get("jobManager");
					jobManager.clear();
					
					StdBackupEngine stdBackup=new StdBackupEngine();
					stdBackup.start();
					logger.info("easybackup.properties already reload." );
				}
				
			} catch (IOException e) {
				logger.error("Read easybackup.properties error.",e );
			}
		}else{
			logger.error("easybackup.properties not found.");
		}
		
	}

}
