package cn.easyproject.easybackup;

import java.io.IOException;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

import cn.easyproject.easybackup.backup.BackupEngine;
import cn.easyproject.easybackup.backup.StdBackupEngine;
import cn.easyproject.easybackup.configuration.GlobalConfiguration;
import cn.easyproject.easybackup.job.ReloadConfigurationJob;

/**
 * EasyBackup Run enter
 * 
 * @author easyproject.cn
 *
 * @since 1.0.0
 */
public class EasyBackup {

	static Logger logger = LoggerFactory.getLogger(EasyBackup.class);

	public static boolean started = false;
	
	
	public void start() {
		if (!started) {
			ResourceLoader rl = new PathMatchingResourcePatternResolver();
			Resource res = rl.getResource("file:easybackup.properties");
			Resource res2 = rl.getResource("classpath:easybackup.properties");

			if((!res.exists()) && (!res2.exists())){
				logger.error("easybackup.properties not found.");
				return;
			}else{
				boolean loadProperties=false;
				if (res.exists()) {
					GlobalConfiguration.properties = new Properties();
					try {
						GlobalConfiguration.properties.load(res.getInputStream());
						ReloadConfigurationJob.propertiesLastModify = res.getFile().lastModified();
						
						BackupEngine stdBackup = new StdBackupEngine();
						stdBackup.start();
						loadProperties=true;
					} catch (IOException e) {
						logger.error("Read file:easybackup.properties error.", e);
					}
				}
				
				if(!loadProperties){
					GlobalConfiguration.properties = new Properties();
					try {
						GlobalConfiguration.properties.load(res2.getInputStream());
						ReloadConfigurationJob.propertiesLastModify = res.getFile().lastModified();

						BackupEngine stdBackup = new StdBackupEngine();
						stdBackup.start();
					} catch (IOException e) {
						logger.error("Read classpath:easybackup.properties error.", e);
					}
				}
				
			}

		}else{
			logger.info("EasyBackup is already started!");
		}
	}

	
	
	public static void main(String[] args) {
		new EasyBackup().start();
	}
}
