/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.flyway;

import cn.dreampie.flyway.DbConfig;
import cn.dreampie.flyway.DbSource;
import com.google.common.collect.Maps;
import com.jfinal.plugin.IPlugin;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flywaydb.core.Flyway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlywayPlugin
implements IPlugin {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String flywayPrefixToMigrationScript = "/db/migration/";
    private DbConfig dbConfig;

    public FlywayPlugin() {
        this.dbConfig = new DbConfig();
    }

    public FlywayPlugin(String config) {
        this.dbConfig = new DbConfig(config);
    }

    public boolean start() {
        List<String> dbNames = this.dbConfig.getAllDbNames();
        boolean dev = this.dbConfig.isDev();
        for (String dbName : dbNames) {
            boolean auto = this.dbConfig.migrateAuto(dbName);
            if (dev || auto) {
                this.migrateAutomatically(dbName);
                continue;
            }
            this.checkState(dbName);
        }
        this.logger.info("flyway inited!");
        return true;
    }

    public boolean stop() {
        List<String> dbNames = this.dbConfig.getAllDbNames();
        for (String dbName : dbNames) {
            this.cleanAutomatically(dbName);
        }
        this.logger.info("flyway stoped!");
        return true;
    }

    private Map<String, Flyway> flyways() {
        HashMap flywayMap = Maps.newHashMap();
        Map<String, DbSource> dbSourceMap = this.dbConfig.getAllDbSources();
        DbSource dbSource = null;
        String migrationFilesLocation = null;
        Flyway flyway = null;
        for (String dbName : dbSourceMap.keySet()) {
            migrationFilesLocation = this.flywayPrefixToMigrationScript + dbName;
            if (!this.dbConfig.migrationFileDirectoryExists(migrationFilesLocation)) continue;
            dbSource = dbSourceMap.get(dbName);
            flyway = new Flyway();
            flyway.setDataSource(dbSource.url, dbSource.user, dbSource.password, new String[0]);
            flyway.setLocations(new String[]{migrationFilesLocation});
            if (this.dbConfig.isClean(dbName)) {
                flyway.setCleanOnValidationError(true);
            }
            if (this.dbConfig.initOnMigrate(dbName)) {
                flyway.setInitOnMigrate(true);
            }
            flywayMap.put(dbName, flyway);
        }
        return flywayMap;
    }

    private void migrateAutomatically(String dbName) {
        Map<String, Flyway> flywayMap = this.flyways();
        flywayMap.get(dbName).migrate();
    }

    private void cleanAutomatically(String dbName) {
        Map<String, Flyway> flywayMap = this.flyways();
        flywayMap.get(dbName).clean();
    }

    private void checkState(String dbName) {
        Map<String, Flyway> flywayMap = this.flyways();
        Object[] pendingMigrations = flywayMap.get(dbName).info().pending();
        if (pendingMigrations != null) {
            throw new RuntimeException(dbName + "-" + StringUtils.join((Object[])pendingMigrations, (String)","));
        }
    }
}

