/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.coffeescript.compiler;

import cn.dreampie.resource.FileResource;
import cn.dreampie.resource.HttpResource;
import cn.dreampie.resource.Resource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoffeeSource {
    private static Logger logger = LoggerFactory.getLogger(CoffeeSource.class);
    private static final Pattern IMPORT_PATTERN = Pattern.compile("^(?!\\s*//\\s*).*(@import\\s+(url\\(|\\((less|css)\\))?\\s*(\"|')(.+)\\s*(\"|')(\\))?(.*);).*$", 8);
    private Resource resource;
    private String content;
    private String normalizedContent;
    private Map<String, CoffeeSource> imports = new LinkedHashMap<String, CoffeeSource>();

    public CoffeeSource(Resource resource) throws IOException {
        this(resource, Charset.defaultCharset());
    }

    public CoffeeSource(Resource resource, Charset charset) throws IOException {
        if (resource == null) {
            throw new IllegalArgumentException("Resource must not be null.");
        }
        if (!resource.exists()) {
            throw new IOException("Resource " + resource + " not found.");
        }
        this.resource = resource;
        this.content = this.normalizedContent = this.loadResource(resource, charset);
        this.resolveImports();
    }

    public CoffeeSource(File input) throws IOException {
        this((Resource)new FileResource(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadResource(Resource resource, Charset charset) throws IOException {
        BOMInputStream inputStream = new BOMInputStream(resource.getInputStream());
        try {
            if (inputStream.hasBOM()) {
                logger.debug("BOM found %s", (Object)inputStream.getBOMCharsetName());
                String string = IOUtils.toString((InputStream)inputStream, (String)inputStream.getBOMCharsetName());
                return string;
            }
            logger.debug("Using charset " + charset.name());
            String string = IOUtils.toString((InputStream)inputStream, (String)charset.name());
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    public String getAbsolutePath() {
        return this.resource.toString();
    }

    public String getContent() {
        return this.content;
    }

    public String getNormalizedContent() {
        return this.normalizedContent;
    }

    public long getLastModified() {
        return this.resource.lastModified();
    }

    public long getLastModifiedIncludingImports() {
        long lastModified = this.getLastModified();
        for (Map.Entry<String, CoffeeSource> entry : this.imports.entrySet()) {
            CoffeeSource importedCoffeeSource = entry.getValue();
            long importedCoffeeSourceLastModified = importedCoffeeSource.getLastModifiedIncludingImports();
            if (importedCoffeeSourceLastModified <= lastModified) continue;
            lastModified = importedCoffeeSourceLastModified;
        }
        return lastModified;
    }

    public Map<String, CoffeeSource> getImports() {
        return this.imports;
    }

    private void resolveImports() throws IOException {
        Matcher importMatcher = IMPORT_PATTERN.matcher(this.normalizedContent);
        while (importMatcher.find()) {
            String importedResource = importMatcher.group(5);
            importedResource = importedResource.matches(".*\\.(le?|c)ss$") ? importedResource : importedResource + ".less";
            String importType = importMatcher.group(3) == null ? importedResource.substring(importedResource.lastIndexOf(".") + 1) : importMatcher.group(3);
            if (!importType.equals("less")) continue;
            logger.debug("Importing %s", (Object)importedResource);
            if (!this.imports.containsKey(importedResource)) {
                CoffeeSource importedCoffeeSource = new CoffeeSource(this.getImportedResource(importedResource));
                this.imports.put(importedResource, importedCoffeeSource);
                this.normalizedContent = this.includeImportedContent(importedCoffeeSource, importMatcher);
                importMatcher = IMPORT_PATTERN.matcher(this.normalizedContent);
                continue;
            }
            this.normalizedContent = this.normalizedContent.substring(0, importMatcher.start(1)) + this.normalizedContent.substring(importMatcher.end(1));
            importMatcher = IMPORT_PATTERN.matcher(this.normalizedContent);
        }
    }

    private Resource getImportedResource(String importedResource) throws IOException {
        try {
            if (importedResource.startsWith("http:") || importedResource.startsWith("https:")) {
                return new HttpResource(importedResource);
            }
            return this.resource.createRelative(importedResource);
        }
        catch (URISyntaxException e) {
            throw (IOException)new IOException(importedResource).initCause(e);
        }
    }

    private String includeImportedContent(CoffeeSource importedCoffeeSource, Matcher importMatcher) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.normalizedContent.substring(0, importMatcher.start(1)));
        String mediaQuery = importMatcher.group(8);
        if (mediaQuery != null && mediaQuery.length() > 0) {
            builder.append("@media");
            builder.append(mediaQuery);
            builder.append("{\n");
        }
        builder.append(importedCoffeeSource.getNormalizedContent());
        if (mediaQuery != null && mediaQuery.length() > 0) {
            builder.append("}\n");
        }
        builder.append(this.normalizedContent.substring(importMatcher.end(1)));
        return builder.toString();
    }

    public String getName() {
        return this.resource.getName();
    }
}

