/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.coffeescript.compiler;

import cn.dreampie.coffeescript.compiler.AbstractCoffeeScript;
import cn.dreampie.coffeescript.compiler.CoffeeException;
import cn.dreampie.coffeescript.compiler.CoffeeSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoffeeScriptList
extends AbstractCoffeeScript {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void execute() throws CoffeeException {
        String[] files;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("sourceDirectory = " + this.sourceDirectory);
            this.logger.debug("includes = " + Arrays.toString(this.includes));
            this.logger.debug("excludes = " + Arrays.toString(this.excludes));
        }
        if ((files = this.getIncludedFiles()) == null || files.length < 1) {
            this.logger.info("No COFFEE sources found");
        } else {
            this.logger.info("The following COFFEE sources have been resolved:");
            for (String file : files) {
                File lessFile = new File(this.sourceDirectory, file);
                try {
                    CoffeeSource lessSource = new CoffeeSource(lessFile);
                    this.listCoffeeSource(lessSource, file, 0, false);
                }
                catch (FileNotFoundException e) {
                    throw new CoffeeException("Error while loading COFFEE source: " + lessFile.getAbsolutePath(), e);
                }
                catch (IOException e) {
                    throw new CoffeeException("Error while loading COFFEE source: " + lessFile.getAbsolutePath(), e);
                }
            }
        }
    }

    private void listCoffeeSource(CoffeeSource lessSource, String path, int level, boolean last) {
        String prefix = "";
        if (level > 0) {
            for (int i = 1; i <= level; ++i) {
                prefix = i == level && last ? prefix + "`-- " : (i == level ? prefix + "|-- " : prefix + "|   ");
            }
        }
        this.logger.info(prefix + path);
        Iterator<Map.Entry<String, CoffeeSource>> it = lessSource.getImports().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, CoffeeSource> entry = it.next();
            this.listCoffeeSource(entry.getValue(), entry.getKey(), level + 1, !it.hasNext());
        }
    }
}

