/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.coffeescript;

import cn.dreampie.coffeescript.compiler.CoffeeCompiler;
import cn.dreampie.coffeescript.compiler.CoffeeException;
import cn.dreampie.coffeescript.compiler.CoffeeExecuteListener;
import cn.dreampie.coffeescript.compiler.CoffeeExecuteThread;
import cn.dreampie.coffeescript.compiler.CoffeeScriptCompiler;
import com.jfinal.kit.PathKit;
import com.jfinal.plugin.IPlugin;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.ThreadBuildContext;

public class CoffeeScriptPlugin
implements IPlugin {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int restartInterval = 1000;
    private CoffeeScriptCompiler coffeeScriptCompiler;

    public CoffeeScriptPlugin() {
        this.setCoffeeScriptCompiler("/coffeescript/", "/javascript/", false, "--bare", true);
    }

    public CoffeeScriptPlugin(String in, String out) {
        this.setCoffeeScriptCompiler(in, out, false, "--bare", true);
    }

    public CoffeeScriptPlugin(CoffeeScriptCompiler coffeeScriptCompiler) {
        this.coffeeScriptCompiler = coffeeScriptCompiler;
    }

    public CoffeeScriptPlugin(int restartInterval, CoffeeScriptCompiler coffeeScriptCompiler) {
        this.restartInterval = restartInterval;
        this.coffeeScriptCompiler = coffeeScriptCompiler;
    }

    private void setCoffeeScriptCompiler(String in, String out, boolean compress, String args, boolean watch) {
        this.coffeeScriptCompiler = new CoffeeScriptCompiler();
        this.coffeeScriptCompiler.setBuildContext(ThreadBuildContext.getContext());
        this.coffeeScriptCompiler.setSourceDirectory(new File(PathKit.getWebRootPath() + in));
        this.coffeeScriptCompiler.setOutputDirectory(new File(PathKit.getWebRootPath() + out));
        this.coffeeScriptCompiler.setCompress(compress);
        this.coffeeScriptCompiler.setArgs(args);
        this.coffeeScriptCompiler.setWatch(watch);
    }

    public boolean start() {
        CoffeeExecuteThread run = new CoffeeExecuteThread(this.coffeeScriptCompiler, this.restartInterval);
        CoffeeExecuteListener listen = new CoffeeExecuteListener(run);
        run.addObserver(listen);
        new Thread(run).start();
        return true;
    }

    public boolean stop() {
        return false;
    }

    public static void main(String[] args) throws IOException, CoffeeException {
        CoffeeCompiler coffeeCompiler = new CoffeeCompiler();
        String js = coffeeCompiler.compile("alert '\u6d4b\u8bd5'");
        coffeeCompiler = new CoffeeCompiler();
        js = coffeeCompiler.compile(new File(PathKit.getWebRootPath() + "/src/main/webapp/javascript/app/main.coffee"));
        CoffeeScriptCompiler coffeeScriptCompiler = new CoffeeScriptCompiler();
        coffeeScriptCompiler.setBuildContext(ThreadBuildContext.getContext());
        coffeeScriptCompiler.setSourceDirectory(new File(PathKit.getWebRootPath() + "/src/main/webapp/javascript/"));
        coffeeScriptCompiler.setForce(true);
        coffeeScriptCompiler.setArgs("--bare");
        coffeeScriptCompiler.setWatch(true);
        coffeeScriptCompiler.execute();
    }
}

