/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.akka;

import akka.actor.ActorSystem;
import com.jfinal.plugin.IPlugin;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AkkaPlugin
implements IPlugin {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean applicationSystemEnabled = false;
    static ActorSystem applicationSystem;
    private String config = "akka.conf";

    public AkkaPlugin() {
    }

    public AkkaPlugin(String config) {
        this.config = config;
    }

    private ActorSystem applicationSystem() {
        this.applicationSystemEnabled = true;
        Config akkaConf = ConfigFactory.load((String)this.config);
        ActorSystem system = ActorSystem.create((String)"application", (Config)akkaConf);
        this.logger.info("Starting application default Akka system.");
        return system;
    }

    public boolean start() {
        applicationSystem = this.applicationSystem();
        return true;
    }

    public boolean stop() {
        if (this.applicationSystemEnabled) {
            this.logger.info("Shutdown application default Akka system.");
            applicationSystem.shutdown();
            applicationSystem.awaitTermination();
        }
        return true;
    }
}

